/**
 * @file Ipc2Bts_MediaPlayer_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_MEDIAPLAYER.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_MEDIAPLAYER.
 */

#ifndef _IPC_2_BTS_MEDIAPLAYER_MSG_GENIVI_H_
#define _IPC_2_BTS_MEDIAPLAYER_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Ipc2Bts_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Ipc2Bts_ServiceAvailabilityMediaPlayer : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceAvailabilityMediaPlayer();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceAvailabilityMediaPlayer(IN const Ipc2Bts_ServiceAvailabilityMediaPlayer& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceAvailabilityMediaPlayer& operator=(IN const Ipc2Bts_ServiceAvailabilityMediaPlayer& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceAvailabilityMediaPlayer();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSGenDbusServiceInterface interface) { _interface = interface; }
   inline void setAvailabilityEvent(IN const BTSDbusServiceAvailability availabilityEvent) { _availabilityEvent = availabilityEvent; }
   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSGenDbusServiceInterface getInterface(void) const { return _interface; }
   inline BTSDbusServiceAvailability getAvailabilityEvent(void) const { return _availabilityEvent; }
   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSGenDbusServiceInterface _interface; /**< parameter interface */
   BTSDbusServiceAvailability _availabilityEvent; /**< parameter availability event */
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //genivi
} //btstackif

#endif //_IPC_2_BTS_MEDIAPLAYER_MSG_GENIVI_H_
