/**
 * @file EvolutionGeniviDbusTraceFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for Trace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Trace.
 */

#include "EvolutionGeniviDbusTraceFactory.h"
#include "EvolutionGeniviDbusTraceCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusTraceFactory::EvolutionGeniviDbusTraceFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusTraceFactory::~EvolutionGeniviDbusTraceFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusTraceFactory& EvolutionGeniviDbusTraceFactory::getInstance(void)
{
   static EvolutionGeniviDbusTraceFactory factory;
   return factory;
}

::ccdbusif::IEvolutionGeniviDbusTraceCallbackIf* EvolutionGeniviDbusTraceFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusTraceCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusTraceFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusTraceFactory::setCbForTesting(EvolutionGeniviDbusTraceCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
