/**
 * @file EvolutionGeniviDbusTraceCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Trace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Trace.
 */

#include "EvolutionGeniviDbusTraceCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"

using namespace ::org::bluez::evo::Trace;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusTraceCallbackIf::EvolutionGeniviDbusTraceCallbackIf()
{
}

EvolutionGeniviDbusTraceCallbackIf::EvolutionGeniviDbusTraceCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusTraceCallbackIf::~EvolutionGeniviDbusTraceCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusTraceCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_TRACE);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusTraceCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_TRACE);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/evo/TraceProxy implementation --- start
void EvolutionGeniviDbusTraceCallbackIf::onDebugTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_DebugTraceConfigResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusTraceCallbackIf::onDebugTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_DebugTraceConfigResult(), response);
}

void EvolutionGeniviDbusTraceCallbackIf::onProtocolTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_ProtocolTraceConfigResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusTraceCallbackIf::onProtocolTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_ProtocolTraceConfigResult(), response);
}

void EvolutionGeniviDbusTraceCallbackIf::onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_ReportDebugTrace(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusTraceCallbackIf::onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_ReportDebugTrace* ptrResultMsg = ptrNew_Ipc2Bts_ReportDebugTrace();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setTraceLocation(signal->getLocation());
      ptrResultMsg->setTraceLevel(signal->getLevel());
      ptrResultMsg->setTraceCategory((BTSDebugTraceCategory)signal->getCategory()); // cast OK, values are matching
      ptrResultMsg->setErrorCode(signal->getError_code());
      ptrResultMsg->setTraceLength((BTSDebugTraceLength)signal->getData().size());
      ptrResultMsg->setTraceData(signal->getData());
      onSignal(ptrResultMsg, signal->getAct());
   }
}

void EvolutionGeniviDbusTraceCallbackIf::onReportProtocolTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_ReportProtocolTrace(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusTraceCallbackIf::onReportProtocolTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_ReportProtocolTrace* ptrResultMsg = ptrNew_Ipc2Bts_ReportProtocolTrace();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setTraceType(signal->getType());
      ptrResultMsg->setTraceDirection((BTSDebugTraceDirection)signal->getDirection()); // cast OK, values are matching
      ptrResultMsg->setTraceLength((BTSDebugTraceLength)signal->getData().size());
      ptrResultMsg->setTraceData(signal->getData());
      onSignal(ptrResultMsg, signal->getAct());
   }
}

void EvolutionGeniviDbusTraceCallbackIf::onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_FatalError(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusTraceCallbackIf::onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_FatalError* ptrResultMsg = ptrNew_Ipc2Bts_FatalError();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setErrLocation(signal->getErr_localtion());
      ptrResultMsg->setErrType(signal->getErr_type());
      onSignal(ptrResultMsg, signal->getAct());
   }
}

void EvolutionGeniviDbusTraceCallbackIf::onGeneralErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_GeneralError(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusTraceCallbackIf::onGeneralErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_GeneralError* ptrResultMsg = ptrNew_Ipc2Bts_GeneralError();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setStatus(convertStatusCode2InternalValue(signal->getStatus()));
      ptrResultMsg->setBinaryStatus(signal->getStatus());
      ptrResultMsg->setOpcode(signal->getOp_code());
      onSignal(ptrResultMsg, signal->getAct());
   }
}
// org/bluez/evo/TraceProxy implementation --- end

} //genivi
} //btstackif
