/**
 * @file EvolutionGeniviDbusSppCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Spp.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Spp.
 */

#include "EvolutionGeniviDbusSppCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"
#include "FwAssert.h"

using namespace ::org::alps::evo::SPP;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusSppCallbackIf::EvolutionGeniviDbusSppCallbackIf()
{
}

EvolutionGeniviDbusSppCallbackIf::EvolutionGeniviDbusSppCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusSppCallbackIf::~EvolutionGeniviDbusSppCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusSppCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_SPP);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusSppCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_SPP);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/alps/evo/SPPProxy implementation --- start
void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataReqError >& error)
{
   (void)(proxy);
   (void)(error);
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataReqResponse >& response)
{
   (void)(proxy);
   (void)(response);
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppSetUuidReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidReqError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_BtApplSppSetUuidReqResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppSetUuidReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidReqResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_BtApplSppSetUuidReqResult(), response);
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppFlowCtrlReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlReqError >& error)
{
   (void)(proxy);
   (void)(error);
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppFlowCtrlReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlReqResponse >& response)
{
   (void)(proxy);
   (void)(response);
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataCfmError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataCfmSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataIndError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataIndSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   // received sometimes => ignore --- FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppSendIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSendIndError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppSendIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSendIndSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   // FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppSetUuidCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidCfmError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppSetUuidCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidCfmSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_BtApplSppSetUuidCfm* ptrResultMsg = ptrNew_Ipc2Bts_BtApplSppSetUuidCfm();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setInstance(signal->getInstance());
      ptrResultMsg->setStatus(convertStatusCode2InternalValue(signal->getStatus()));
      onSignal(ptrResultMsg, signal->getAct());
   }
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppFlowCtrlCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlCfmError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppFlowCtrlCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlCfmSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataSendFcIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataSendFcIndError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusSppCallbackIf::onBtApplSppDataSendFcIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataSendFcIndSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   // received sometimes => ignore --- FW_NORMAL_ASSERT_ALWAYS();
}
// org/alps/evo/SPPProxy implementation --- end

} //genivi
} //btstackif
