/**
 * @file EvolutionGeniviDbusObexTransferCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for ObexTransfer.
 */

#include "EvolutionGeniviDbusObexTransferCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"

using namespace ::org::bluez::obex::Transfer;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusObexTransferCallbackIf::EvolutionGeniviDbusObexTransferCallbackIf()
{
}

EvolutionGeniviDbusObexTransferCallbackIf::EvolutionGeniviDbusObexTransferCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusObexTransferCallbackIf::~EvolutionGeniviDbusObexTransferCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusObexTransferCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}

void EvolutionGeniviDbusObexTransferCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/obex/TransferProxy implementation --- start
void EvolutionGeniviDbusObexTransferCallbackIf::onCancelError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onCancelResponse(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onStatusError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onStatusUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onSessionError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onSessionUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onNameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onNameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onTypeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onTypeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onTimeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onTimeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onSizeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onSizeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onTransferredError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onTransferredUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onFilenameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexTransferCallbackIf::onFilenameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}
// org/bluez/obex/TransferProxy implementation --- end

} //genivi
} //btstackif
