/**
 * @file EvolutionGeniviDbusObexSessionFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for ObexSession.
 */

#include "EvolutionGeniviDbusObexSessionFactory.h"
#include "EvolutionGeniviDbusObexSessionCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusObexSessionFactory::EvolutionGeniviDbusObexSessionFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusObexSessionFactory::~EvolutionGeniviDbusObexSessionFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusObexSessionFactory& EvolutionGeniviDbusObexSessionFactory::getInstance(void)
{
   static EvolutionGeniviDbusObexSessionFactory factory;
   return factory;
}

::ccdbusif::IEvolutionGeniviDbusObexSessionCallbackIf* EvolutionGeniviDbusObexSessionFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusObexSessionCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusObexSessionFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusObexSessionFactory::setCbForTesting(EvolutionGeniviDbusObexSessionCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
