/**
 * @file EvolutionGeniviDbusHfpVoiceCallCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpVoiceCall.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpVoiceCall.
 */

#include "EvolutionGeniviDbusHfpVoiceCallCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"

using namespace ::org::ofono::VoiceCall;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpVoiceCallCallbackIf::EvolutionGeniviDbusHfpVoiceCallCallbackIf()
{
}

EvolutionGeniviDbusHfpVoiceCallCallbackIf::EvolutionGeniviDbusHfpVoiceCallCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpVoiceCallCallbackIf::~EvolutionGeniviDbusHfpVoiceCallCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/VoiceCallProxy implementation --- start
void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onHangupError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onHangupResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onAnswerError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onAnswerResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onHoldError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onHoldResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
}
// org/ofono/VoiceCallProxy implementation --- end

} //genivi
} //btstackif
