/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for HfpNetworkRegistration.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpNetworkRegistration.
 */

#include "EvolutionGeniviDbusHfpNetworkRegistrationFactory.h"
#include "EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpNetworkRegistrationFactory::EvolutionGeniviDbusHfpNetworkRegistrationFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusHfpNetworkRegistrationFactory::~EvolutionGeniviDbusHfpNetworkRegistrationFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusHfpNetworkRegistrationFactory& EvolutionGeniviDbusHfpNetworkRegistrationFactory::getInstance(void)
{
   static EvolutionGeniviDbusHfpNetworkRegistrationFactory factory;
   return factory;
}

::ccdbusif::IEvolutionGeniviDbusHfpNetworkRegistrationCallbackIf* EvolutionGeniviDbusHfpNetworkRegistrationFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusHfpNetworkRegistrationFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationFactory::setCbForTesting(EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
