/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpNetworkRegistration.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpNetworkRegistration.
 */

#include "EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"

using namespace ::org::ofono::NetworkRegistration;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf()
{
}

EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::~EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
   (void)(currentState);
   (void)(objPath);
}

void EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
   (void)(currentState);
   (void)(objPath);
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/NetworkRegistrationProxy implementation --- start
void EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< NetworkRegistrationProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< NetworkRegistrationProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< NetworkRegistrationProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpNetworkRegistrationCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< NetworkRegistrationProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   // TODO: implement
   (void)(proxy);
   (void)(signal);
}
// org/ofono/NetworkRegistrationProxy implementation --- end

} //genivi
} //btstackif
