/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpNetworkOperator.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpNetworkOperator.
 */

#include "EvolutionGeniviDbusHfpNetworkOperatorCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"

using namespace ::org::ofono::NetworkOperator;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::EvolutionGeniviDbusHfpNetworkOperatorCallbackIf()
{
}

EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::EvolutionGeniviDbusHfpNetworkOperatorCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::~EvolutionGeniviDbusHfpNetworkOperatorCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
   (void)(currentState);
   (void)(objPath);
}

void EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
   (void)(currentState);
   (void)(objPath);
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/NetworkOperatorProxy implementation --- start
void EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpNetworkOperatorCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   // TODO: implement
   (void)(proxy);
   (void)(signal);
}
// org/ofono/NetworkOperatorProxy implementation --- end

} //genivi
} //btstackif
