/**
 * @file EvolutionGeniviDbusHfpCallVolumeCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpCallVolume.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpCallVolume.
 */

#include "EvolutionGeniviDbusHfpCallVolumeCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"

using namespace ::org::ofono::CallVolume;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpCallVolumeCallbackIf::EvolutionGeniviDbusHfpCallVolumeCallbackIf()
{
}

EvolutionGeniviDbusHfpCallVolumeCallbackIf::EvolutionGeniviDbusHfpCallVolumeCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpCallVolumeCallbackIf::~EvolutionGeniviDbusHfpCallVolumeCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
   (void)(currentState);
   (void)(objPath);
}

void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
   (void)(currentState);
   (void)(objPath);
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/CallVolumeProxy implementation --- start
void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onSetPropertyError(const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onSetPropertyResponse(const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpCallVolumeCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< CallVolumeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   // TODO: implement
   (void)(proxy);
   (void)(signal);
}
// org/ofono/CallVolumeProxy implementation --- end

} //genivi
} //btstackif
