/**
 * @file EvolutionGeniviDbusDidCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Did.
 */

#include "EvolutionGeniviDbusDidCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"

using namespace ::org::alps::evo::DID;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusDidCallbackIf::EvolutionGeniviDbusDidCallbackIf()
{
}

EvolutionGeniviDbusDidCallbackIf::EvolutionGeniviDbusDidCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusDidCallbackIf::~EvolutionGeniviDbusDidCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusDidCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_DID);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusDidCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_DID);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/alps/evo/DIDProxy implementation --- start
void EvolutionGeniviDbusDidCallbackIf::onBtApplDidSetReqError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_BtApplDidSetReqResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusDidCallbackIf::onBtApplDidSetReqResponse(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_BtApplDidSetReqResult(), response);
}

void EvolutionGeniviDbusDidCallbackIf::onBtApplDidSetCfmError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_BtApplDidSetCfm(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusDidCallbackIf::onBtApplDidSetCfmSignal(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_BtApplDidSetCfm* ptrMsg = ptrNew_Ipc2Bts_BtApplDidSetCfm();
   if(NULL != ptrMsg)
   {
      ptrMsg->setStatus(convertStatusCode2InternalValue(signal->getStatus()));
   }
   onSignal(ptrMsg, signal->getAct());
}
// org/alps/evo/DIDProxy implementation --- end

} //genivi
} //btstackif
