/**
 * @file EvolutionGeniviDbusAgentManagerCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for AgentManager.
 */

#include "EvolutionGeniviDbusAgentManagerCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"

using namespace ::org::bluez::AgentManager;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusAgentManagerCallbackIf::EvolutionGeniviDbusAgentManagerCallbackIf()
{
}

EvolutionGeniviDbusAgentManagerCallbackIf::EvolutionGeniviDbusAgentManagerCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusAgentManagerCallbackIf::~EvolutionGeniviDbusAgentManagerCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusAgentManagerCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_AGENT_MANAGER);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusAgentManagerCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_AGENT_MANAGER);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/AgentManagerProxy implementation --- start
void EvolutionGeniviDbusAgentManagerCallbackIf::onRegisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_RegisterAgentResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusAgentManagerCallbackIf::onRegisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_RegisterAgentResult(), response);
}

void EvolutionGeniviDbusAgentManagerCallbackIf::onUnregisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_UnregisterAgentResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusAgentManagerCallbackIf::onUnregisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_UnregisterAgentResult(), response);
}

void EvolutionGeniviDbusAgentManagerCallbackIf::onRequestDefaultAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_RequestDefaultAgentResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusAgentManagerCallbackIf::onRequestDefaultAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_RequestDefaultAgentResult(), response);
}
// org/bluez/AgentManagerProxy implementation --- end

} //genivi
} //btstackif
