/**
 * @file ConnManDbusTechnologyCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan DBUS Callback Interface for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Callback Interface for Technology.
 */

#include "ConnManDbusTechnologyCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
// #include "BtsUtils.h"
#include "FwAssert.h"

using namespace ::net::connman::Technology;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

ConnManDbusTechnologyCallbackIf::ConnManDbusTechnologyCallbackIf()
{
}

ConnManDbusTechnologyCallbackIf::ConnManDbusTechnologyCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

ConnManDbusTechnologyCallbackIf::~ConnManDbusTechnologyCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void ConnManDbusTechnologyCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_CONNMAN_TECHNOLOGY);
      ptrMsg->setObjPath(objPath);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void ConnManDbusTechnologyCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_CONNMAN_TECHNOLOGY);
      ptrMsg->setObjPath(objPath);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// net/connman/TechnologyProxy implementation --- start
void ConnManDbusTechnologyCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   (void)(proxy);
   (void)(error);
}

void ConnManDbusTechnologyCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void ConnManDbusTechnologyCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void ConnManDbusTechnologyCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
}
// net/connman/TechnologyProxy implementation --- end

} //genivi
} //btstackif
