/**
 * @file PropertiesGetAllDbusCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief PropertiesGetAll DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for PropertiesGetAll DBUS callbacks.
 */

#ifndef _PROPERTIES_GET_ALL_DBUS_CALLBACK_IF_H_
#define _PROPERTIES_GET_ALL_DBUS_CALLBACK_IF_H_

#include "cc_dbus_if/IPropertiesGetAllDbusCallbackIf.h"

#include "getall/org/freedesktop/DBus/PropertiesProxy.h"

#include "DbusCallbackIf.h"

using namespace ::getall::org::freedesktop::DBus::Properties;

using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class PropertiesGetAllDbusCallbackIf : public DbusCallbackIf, public ::ccdbusif::IPropertiesGetAllDbusCallbackIf
{
public:
   PropertiesGetAllDbusCallbackIf(IDbusRecHandler* recHandler);
   virtual ~PropertiesGetAllDbusCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onPropertiesGetAllProxyAvailable(const ::std::string& busName, const ::std::string& objPath, const ::ccdbusif::DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState);
   virtual void onPropertiesGetAllProxyUnavailable(const ::std::string& busName, const ::std::string& objPath, const ::ccdbusif::DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState);
   // "ServiceAvailableIF" implementation --- end

   // PropertiesProxy implementation --- start
   virtual void onGetAllError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllError >& error);
   virtual void onGetAllResponse(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllResponse >& response);
   // PropertiesProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   PropertiesGetAllDbusCallbackIf();
};

} //genivi
} //btstackif

#endif //_PROPERTIES_GET_ALL_DBUS_CALLBACK_IF_H_
