/**
 * @file EvolutionGeniviDbusTraceCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Trace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Trace.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_TRACE_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_TRACE_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusTraceCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/evo/TraceProxy.h"

using namespace ::org::bluez::evo::Trace;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusTraceCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusTraceCallbackIf
{
public:
   EvolutionGeniviDbusTraceCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusTraceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/evo/TraceProxy implementation --- start
   virtual void onDebugTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigError >& error);

   virtual void onDebugTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigResponse >& response);

   virtual void onProtocolTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigError >& error);

   virtual void onProtocolTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigResponse >& response);

   virtual void onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error);

   virtual void onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal);

   virtual void onReportProtocolTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceError >& error);

   virtual void onReportProtocolTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceSignal >& signal);

   virtual void onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error);

   virtual void onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal);

   virtual void onGeneralErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorError >& error);

   virtual void onGeneralErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorSignal >& signal);
   // org/bluez/evo/TraceProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusTraceCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_TRACE_CALLBACK_IF_H_
