/**
 * @file EvolutionGeniviDbusSppCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Spp.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Spp.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SPP_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_SPP_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusSppCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/alps/evo/SPPProxy.h"

using namespace ::org::alps::evo::SPP;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusSppCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusSppCallbackIf
{
public:
   EvolutionGeniviDbusSppCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusSppCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/SPPProxy implementation --- start
   virtual void onBtApplSppDataReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataReqError >& error);

   virtual void onBtApplSppDataReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataReqResponse >& response);

   virtual void onBtApplSppSetUuidReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidReqError >& error);

   virtual void onBtApplSppSetUuidReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidReqResponse >& response);

   virtual void onBtApplSppFlowCtrlReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlReqError >& error);

   virtual void onBtApplSppFlowCtrlReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlReqResponse >& response);

   virtual void onBtApplSppDataCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataCfmError >& error);

   virtual void onBtApplSppDataCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataCfmSignal >& signal);

   virtual void onBtApplSppDataIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataIndError >& error);

   virtual void onBtApplSppDataIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataIndSignal >& signal);

   virtual void onBtApplSppSendIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSendIndError >& error);

   virtual void onBtApplSppSendIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSendIndSignal >& signal);

   virtual void onBtApplSppSetUuidCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidCfmError >& error);

   virtual void onBtApplSppSetUuidCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidCfmSignal >& signal);

   virtual void onBtApplSppFlowCtrlCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlCfmError >& error);

   virtual void onBtApplSppFlowCtrlCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlCfmSignal >& signal);

   virtual void onBtApplSppDataSendFcIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataSendFcIndError >& error);

   virtual void onBtApplSppDataSendFcIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataSendFcIndSignal >& signal);
   // org/alps/evo/SPPProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusSppCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_SPP_CALLBACK_IF_H_
