/**
 * @file EvolutionGeniviDbusObexTransferCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for ObexTransfer.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusObexTransferCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/obex/TransferProxy.h"

using namespace ::org::bluez::obex::Transfer;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusObexTransferCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusObexTransferCallbackIf
{
public:
   EvolutionGeniviDbusObexTransferCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusObexTransferCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/obex/TransferProxy implementation --- start
   virtual void onCancelError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelError >& error);

   virtual void onCancelResponse(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response);

   virtual void onStatusError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusError >& error);

   virtual void onStatusUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update);

   virtual void onSessionError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionError >& error);

   virtual void onSessionUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SessionUpdate >& update);

   virtual void onNameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameError >& error);

   virtual void onNameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< NameUpdate >& update);

   virtual void onTypeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeError >& error);

   virtual void onTypeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TypeUpdate >& update);

   virtual void onTimeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeError >& error);

   virtual void onTimeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TimeUpdate >& update);

   virtual void onSizeError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeError >& error);

   virtual void onSizeUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< SizeUpdate >& update);

   virtual void onTransferredError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredError >& error);

   virtual void onTransferredUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< TransferredUpdate >& update);

   virtual void onFilenameError(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameError >& error);

   virtual void onFilenameUpdate(const ::boost::shared_ptr< TransferProxy >& proxy, const ::boost::shared_ptr< FilenameUpdate >& update);
   // org/bluez/obex/TransferProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusObexTransferCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_CALLBACK_IF_H_
