/**
 * @file EvolutionGeniviDbusObexSessionCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for ObexSession.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_SESSION_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_SESSION_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusObexSessionCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/obex/SessionProxy.h"

using namespace ::org::bluez::obex::Session;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusObexSessionCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusObexSessionCallbackIf
{
public:
   EvolutionGeniviDbusObexSessionCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusObexSessionCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/obex/SessionProxy implementation --- start
   virtual void onSourceError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceError >& error);

   virtual void onSourceUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceUpdate >& update);

   virtual void onDestinationError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationError >& error);

   virtual void onDestinationUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationUpdate >& update);

   virtual void onChannelError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelError >& error);

   virtual void onChannelUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelUpdate >& update);

   virtual void onTargetError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetError >& error);

   virtual void onTargetUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetUpdate >& update);
   // org/bluez/obex/SessionProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusObexSessionCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_SESSION_CALLBACK_IF_H_
