/**
 * @file EvolutionGeniviDbusObexClientCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for ObexClient.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusObexClientCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/obex/ClientProxy.h"

using namespace ::org::bluez::obex::Client;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusObexClientCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusObexClientCallbackIf
{
public:
   EvolutionGeniviDbusObexClientCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusObexClientCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/obex/ClientProxy implementation --- start
   virtual void onCancelSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionError >& error);

   virtual void onCancelSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionResponse >& response);

   virtual void onCreateSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error);

   virtual void onCreateSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response);

   virtual void onRemoveSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionError >& error);

   virtual void onRemoveSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionResponse >& response);

   virtual void onSessionCreatedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedError >& error);

   virtual void onSessionCreatedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedSignal >& signal);

   virtual void onSessionRemovedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedError >& error);

   virtual void onSessionRemovedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedSignal >& signal);
   // org/bluez/obex/ClientProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusObexClientCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_CALLBACK_IF_H_
