/**
 * @file EvolutionGeniviDbusLESeamlessPairingCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for LESeamlessPairing.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusLESeamlessPairingCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/SeamlessPairingProxy.h"

using namespace ::org::bluez::SeamlessPairing;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusLESeamlessPairingCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusLESeamlessPairingCallbackIf
{
public:
   EvolutionGeniviDbusLESeamlessPairingCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusLESeamlessPairingCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/SeamlessPairingProxy implementation --- start
   virtual void onSendErrorCodeError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeError >& error);

   virtual void onSendErrorCodeResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeResponse >& response);

   virtual void onAllowAccessError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessError >& error);

   virtual void onAllowAccessResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessResponse >& response);

   virtual void onErrorCodeReceivedError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedError >& error);

   virtual void onErrorCodeReceivedSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedSignal >& signal);

   virtual void onAccessRequestError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestError >& error);

   virtual void onAccessRequestSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestSignal >& signal);

   virtual void onPairingDataError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataError >& error);

   virtual void onPairingDataUpdate(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataUpdate >& update);
   // org/bluez/SeamlessPairingProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusLESeamlessPairingCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_CALLBACK_IF_H_
