/**
 * @file EvolutionGeniviDbusLEDeviceCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for LEDevice.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for LEDevice.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_DEVICE_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_LE_DEVICE_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusLEDeviceCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/LE_Device1Proxy.h"

using namespace ::org::bluez::LE_Device1;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusLEDeviceCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusLEDeviceCallbackIf
{
public:
   EvolutionGeniviDbusLEDeviceCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusLEDeviceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/LE_Device1Proxy implementation --- start
   virtual void onDisconnectError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error);

   virtual void onDisconnectResponse(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response);

   virtual void onDisconnectionCompError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectionCompError >& error);

   virtual void onDisconnectionCompSignal(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectionCompSignal >& signal);

   virtual void onAddressTypeError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeError >& error);

   virtual void onAddressTypeUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeUpdate >& update);

   virtual void onAddressError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error);

   virtual void onAddressUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update);

   virtual void onConnectedError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error);

   virtual void onConnectedUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update);
   // org/bluez/LE_Device1Proxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusLEDeviceCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_LE_DEVICE_CALLBACK_IF_H_
