/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpVoiceCallManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/ofono/VoiceCallManagerProxy.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf
{
public:
   EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/VoiceCallManagerProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onGetCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsError >& error);

   virtual void onGetCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsResponse >& response);

   virtual void onDialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialError >& error);

   virtual void onDialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialResponse >& response);

   virtual void onMemDialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialError >& error);

   virtual void onMemDialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialResponse >& response);

   virtual void onRedialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialError >& error);

   virtual void onRedialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialResponse >& response);

   virtual void onSwapCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsError >& error);

   virtual void onSwapCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsResponse >& response);

   virtual void onReleaseAndAnswerError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndAnswerError >& error);

   virtual void onReleaseAndAnswerResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndAnswerResponse >& response);

   virtual void onReleaseAndSwapError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndSwapError >& error);

   virtual void onReleaseAndSwapResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndSwapResponse >& response);

   virtual void onHoldAndAnswerError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HoldAndAnswerError >& error);

   virtual void onHoldAndAnswerResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HoldAndAnswerResponse >& response);

   virtual void onHangupAllError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllError >& error);

   virtual void onHangupAllResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllResponse >& response);

   virtual void onPrivateChatError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatError >& error);

   virtual void onPrivateChatResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatResponse >& response);

   virtual void onCreateMultipartyError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CreateMultipartyError >& error);

   virtual void onCreateMultipartyResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CreateMultipartyResponse >& response);

   virtual void onHangupMultipartyError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupMultipartyError >& error);

   virtual void onHangupMultipartyResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupMultipartyResponse >& response);

   virtual void onSendTonesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SendTonesError >& error);

   virtual void onSendTonesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SendTonesResponse >& response);

   virtual void onCallAddedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedError >& error);

   virtual void onCallAddedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedSignal >& signal);

   virtual void onCallRemovedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedError >& error);

   virtual void onCallRemovedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedSignal >& signal);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);
   // org/ofono/VoiceCallManagerProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_CALLBACK_IF_H_
