/**
 * @file EvolutionGeniviDbusHfpVoiceCallCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpVoiceCall.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpVoiceCall.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusHfpVoiceCallCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/ofono/VoiceCallProxy.h"

using namespace ::org::ofono::VoiceCall;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpVoiceCallCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusHfpVoiceCallCallbackIf
{
public:
   EvolutionGeniviDbusHfpVoiceCallCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpVoiceCallCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/VoiceCallProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onHangupError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupError >& error);

   virtual void onHangupResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupResponse >& response);

   virtual void onAnswerError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerError >& error);

   virtual void onAnswerResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerResponse >& response);

   virtual void onHoldError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldError >& error);

   virtual void onHoldResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);
   // org/ofono/VoiceCallProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusHfpVoiceCallCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_CALLBACK_IF_H_
