/**
 * @file EvolutionGeniviDbusHfpSiriCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpSiri.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_SIRI_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_SIRI_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusHfpSiriCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/ofono/evo/SiriProxy.h"

using namespace ::org::ofono::evo::Siri;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpSiriCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusHfpSiriCallbackIf
{
public:
   EvolutionGeniviDbusHfpSiriCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpSiriCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/evo/SiriProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onEnableError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< EnableError >& error);

   virtual void onEnableResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< EnableResponse >& response);

   virtual void onSetNRError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetNRError >& error);

   virtual void onSetNRResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetNRResponse >& response);

   virtual void onSetPropertyError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error);

   virtual void onSetPropertyResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);
   // org/ofono/evo/SiriProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusHfpSiriCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_SIRI_CALLBACK_IF_H_
