/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpNetworkOperator.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpNetworkOperator.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/ofono/NetworkOperatorProxy.h"

using namespace ::org::ofono::NetworkOperator;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpNetworkOperatorCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf
{
public:
   EvolutionGeniviDbusHfpNetworkOperatorCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpNetworkOperatorCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/NetworkOperatorProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< NetworkOperatorProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);
   // org/ofono/NetworkOperatorProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusHfpNetworkOperatorCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_CALLBACK_IF_H_
