/**
 * @file EvolutionGeniviDbusHfpModemFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for HfpModem.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpModem.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MODEM_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MODEM_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusHfpHandsfreeSendRequestIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class IEvolutionGeniviHfpModemCallbackIf;

/**
 *
 */
class EvolutionGeniviDbusHfpModemFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusHfpModemFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   IEvolutionGeniviHfpModemCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(IEvolutionGeniviHfpModemCallbackIf* testCallback);

   /**
    * Set receive handler (pointer).
    *
    * @param[in] handler: receive handler
    */
   void setReceiveHandler(IDbusRecHandler* handler);

   /**
    * Set send request interface (pointer).
    *
    * @param[in] handler: send request interface
    */
   void setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusHfpModemFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusHfpModemFactory();

   bool _createdLocally; /**< creator flag */
   IEvolutionGeniviHfpModemCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MODEM_FACTORY_H_
