/**
 * @file EvolutionGeniviDbusHfpManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MANAGER_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MANAGER_CALLBACK_IF_H_

#include "IEvolutionGeniviHfpManagerCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::org::ofono::Manager;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpManagerCallbackIf : public DbusCallbackIf, public IEvolutionGeniviHfpManagerCallbackIf
{
public:
   EvolutionGeniviDbusHfpManagerCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/ManagerProxy implementation --- start
   virtual void onGetModemsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetModemsError >& error);

   virtual void onGetModemsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetModemsResponse >& response);

   virtual void onModemAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemAddedError >& error);

   virtual void onModemAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemAddedSignal >& signal);

   virtual void onModemRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemRemovedError >& error);

   virtual void onModemRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemRemovedSignal >& signal);
   // org/ofono/ManagerProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler);

   virtual void setHfpModemIf(::ccdbusif::IEvolutionGeniviDbusHfpModemSendRequestIf* handler);

protected:
   EvolutionGeniviDbusHfpManagerCallbackIf();

private:
   ::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* _hfpHandsfreeIf;
   ::ccdbusif::IEvolutionGeniviDbusHfpModemSendRequestIf* _hfpModemIf;

   void handleModemAdded(const BTSFunctionBlock destFuncBlock, const ::std::string& modemObjPath, ::std::map< ::std::string, ::asf::dbus::DBusVariant >& inProperties,
         const ::ccdbusif::DbusBusType busType, const ::std::string& busName, const ::std::string& objPath, const ::std::string& interfaceName, const act_t token);
};

/*
 * inline methods
 */
inline void EvolutionGeniviDbusHfpManagerCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void EvolutionGeniviDbusHfpManagerCallbackIf::setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler)
{
   _hfpHandsfreeIf = handler;
}

inline void EvolutionGeniviDbusHfpManagerCallbackIf::setHfpModemIf(::ccdbusif::IEvolutionGeniviDbusHfpModemSendRequestIf* handler)
{
   _hfpModemIf = handler;
}

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MANAGER_CALLBACK_IF_H_
