/**
 * @file EvolutionGeniviDbusHfpHandsfreeCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpHandsfree.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusHfpHandsfreeCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/ofono/HandsfreeProxy.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpHandsfreeCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeCallbackIf
{
public:
   EvolutionGeniviDbusHfpHandsfreeCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpHandsfreeCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/HandsfreeProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onSetPropertyError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error);

   virtual void onSetPropertyResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response);

   virtual void onRequestPhoneNumberError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberError >& error);

   virtual void onRequestPhoneNumberResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberResponse >& response);

   virtual void onGetSubscriberError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberError >& error);

   virtual void onGetSubscriberResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberResponse >& response);

   virtual void onSendCustomATCommandError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandError >& error);

   virtual void onSendCustomATCommandResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);

   virtual void onRecvATCommandError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandError >& error);

   virtual void onRecvATCommandSignal(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandSignal >& signal);
   // org/ofono/HandsfreeProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusHfpHandsfreeCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_CALLBACK_IF_H_
