/**
 * @file EvolutionGeniviDbusGeniviTraceFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for GeniviTrace.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusGeniviTraceCallbackIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class EvolutionGeniviDbusGeniviTraceCallbackIf;

/**
 *
 */
class EvolutionGeniviDbusGeniviTraceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusGeniviTraceFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   ::ccdbusif::IEvolutionGeniviDbusGeniviTraceCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(EvolutionGeniviDbusGeniviTraceCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusGeniviTraceFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusGeniviTraceFactory();

   bool _createdLocally; /**< creator flag */
   EvolutionGeniviDbusGeniviTraceCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_FACTORY_H_
