/**
 * @file EvolutionGeniviDbusGeniviTraceCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for GeniviTrace.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusGeniviTraceCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/genivi/TraceProxy.h"

using namespace ::org::bluez::genivi::Trace;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusGeniviTraceCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusGeniviTraceCallbackIf
{
public:
   EvolutionGeniviDbusGeniviTraceCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusGeniviTraceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/genivi/TraceProxy implementation --- start
   virtual void onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error);

   virtual void onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal);

   virtual void onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error);

   virtual void onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal);
   // org/bluez/genivi/TraceProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusGeniviTraceCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_CALLBACK_IF_H_
