/**
 * @file EvolutionGeniviDbusDidCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Did.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DID_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DID_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusDidCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/alps/evo/DIDProxy.h"

using namespace ::org::alps::evo::DID;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusDidCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusDidCallbackIf
{
public:
   EvolutionGeniviDbusDidCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusDidCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/DIDProxy implementation --- start
   virtual void onBtApplDidSetReqError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqError >& error);

   virtual void onBtApplDidSetReqResponse(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqResponse >& response);

   virtual void onBtApplDidSetCfmError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmError >& error);

   virtual void onBtApplDidSetCfmSignal(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmSignal >& signal);
   // org/alps/evo/DIDProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusDidCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_DID_CALLBACK_IF_H_
