/**
 * @file EvolutionGeniviDbusDeviceCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Device.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Device.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DEVICE_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DEVICE_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusDeviceCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/Device1Proxy.h"

using namespace ::org::bluez::Device1;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusDeviceCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusDeviceCallbackIf
{
public:
   EvolutionGeniviDbusDeviceCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusDeviceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/Device1Proxy implementation --- start
   virtual void onConnectError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectError >& error);

   virtual void onConnectResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response);

   virtual void onDisconnectError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error);

   virtual void onDisconnectResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response);

   virtual void onPairError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairError >& error);

   virtual void onPairResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairResponse >& response);

   virtual void onCancelPairingError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelPairingError >& error);

   virtual void onCancelPairingResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelPairingResponse >& response);

   virtual void onDiscoverServicesError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DiscoverServicesError >& error);

   virtual void onDiscoverServicesResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DiscoverServicesResponse >& response);

   virtual void onCancelDiscoveryError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelDiscoveryError >& error);

   virtual void onCancelDiscoveryResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelDiscoveryResponse >& response);

   virtual void onReportLinkkeyError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ReportLinkkeyError >& error);

   virtual void onReportLinkkeySignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ReportLinkkeySignal >& signal);

   virtual void onIncomingPairingCompError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IncomingPairingCompError >& error);

   virtual void onIncomingPairingCompSignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IncomingPairingCompSignal >& signal);

   virtual void onAddressError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error);

   virtual void onAddressUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update);

   virtual void onClassError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ClassError >& error);

   virtual void onClassUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ClassUpdate >& update);

   virtual void onIconError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IconError >& error);

   virtual void onIconUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IconUpdate >& update);

   virtual void onUUIDsError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< UUIDsError >& error);

   virtual void onUUIDsUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< UUIDsUpdate >& update);

   virtual void onPairedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairedError >& error);

   virtual void onPairedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairedUpdate >& update);

   virtual void onConnectedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error);

   virtual void onConnectedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update);

   virtual void onTrustedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< TrustedError >& error);

   virtual void onTrustedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< TrustedUpdate >& update);

   virtual void onBlockedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< BlockedError >& error);

   virtual void onBlockedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< BlockedUpdate >& update);

   virtual void onAliasError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error);

   virtual void onAliasUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update);

   virtual void onAdapterError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AdapterError >& error);

   virtual void onAdapterUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AdapterUpdate >& update);

   virtual void onModaliasError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModaliasError >& error);

   virtual void onModaliasUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModaliasUpdate >& update);

   virtual void onRSSIError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RSSIError >& error);

   virtual void onRSSIUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RSSIUpdate >& update);

   virtual void onVendorError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorError >& error);

   virtual void onVendorUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorUpdate >& update);

   virtual void onVendorSourceError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorSourceError >& error);

   virtual void onVendorSourceUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorSourceUpdate >& update);

   virtual void onProductError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ProductError >& error);

   virtual void onProductUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ProductUpdate >& update);

   virtual void onMapInfoError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< MapInfoError >& error);

   virtual void onMapInfoUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< MapInfoUpdate >& update);

   virtual void onConnectedServiceError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedServiceError >& error);

   virtual void onConnectedServiceUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedServiceUpdate >& update);

   virtual void onVersionError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VersionError >& error);

   virtual void onVersionUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update);

   virtual void onPBAPInfoError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PBAPInfoError >& error);

   virtual void onPBAPInfoUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PBAPInfoUpdate >& update);

   virtual void onModeError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModeError >& error);

   virtual void onModeUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModeUpdate >& update);

   virtual void onRoleError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RoleError >& error);

   virtual void onRoleUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RoleUpdate >& update);

   virtual void onSDPProcessReportError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< SDPProcessReportError >& error);

   virtual void onSDPProcessReportSignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< SDPProcessReportSignal >& signal);

   virtual void onEnableAvpPauseError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< EnableAvpPauseError >& error);

   virtual void onEnableAvpPauseUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< EnableAvpPauseUpdate >& update);
   // org/bluez/Device1Proxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusDeviceCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_DEVICE_CALLBACK_IF_H_
