/**
 * @file EvolutionGeniviDbusDMCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for DM.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for DM.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DM_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DM_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusDMCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/alps/evo/DMProxy.h"

using namespace ::org::alps::evo::DM;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusDMCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusDMCallbackIf
{
public:
   EvolutionGeniviDbusDMCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusDMCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/DMProxy implementation --- start
   virtual void onBtApplDeviceConnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectReqError >& error);

   virtual void onBtApplDeviceConnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectReqResponse >& response);

   virtual void onBtApplDeviceDisconnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectReqError >& error);

   virtual void onBtApplDeviceDisconnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectReqResponse >& response);

   virtual void onBtApplCancelConnectReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectReqError >& error);

   virtual void onBtApplCancelConnectReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectReqResponse >& response);

   virtual void onBtApplGetHwVersionReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionReqError >& error);

   virtual void onBtApplGetHwVersionReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionReqResponse >& response);

   virtual void onBtApplSetConfigurationReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationReqError >& error);

   virtual void onBtApplSetConfigurationReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationReqResponse >& response);

   virtual void onBtApplReadConfigurationReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationReqError >& error);

   virtual void onBtApplReadConfigurationReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationReqResponse >& response);

   virtual void onBtApplSspDebugModeReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSspDebugModeReqError >& error);

   virtual void onBtApplSspDebugModeReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSspDebugModeReqResponse >& response);

   virtual void onBtApplTestModeReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeReqError >& error);

   virtual void onBtApplTestModeReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeReqResponse >& response);

   virtual void onBtApplTestModeLinkQualityReqError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityReqError >& error);

   virtual void onBtApplTestModeLinkQualityReqResponse(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityReqResponse >& response);

   virtual void onBtApplDeviceConnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCfmError >& error);

   virtual void onBtApplDeviceConnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCfmSignal >& signal);

   virtual void onBtApplDeviceConnectIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectIndError >& error);

   virtual void onBtApplDeviceConnectIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectIndSignal >& signal);

   virtual void onBtApplDeviceDisconnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCfmError >& error);

   virtual void onBtApplDeviceDisconnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCfmSignal >& signal);

   virtual void onBtApplDeviceDisconnectIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectIndError >& error);

   virtual void onBtApplDeviceDisconnectIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectIndSignal >& signal);

   virtual void onBtApplDeviceDisconnectCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCompIndError >& error);

   virtual void onBtApplDeviceDisconnectCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceDisconnectCompIndSignal >& signal);

   virtual void onBtApplDeviceConnectCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCompIndError >& error);

   virtual void onBtApplDeviceConnectCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplDeviceConnectCompIndSignal >& signal);

   virtual void onBtApplCancelConnectCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectCfmError >& error);

   virtual void onBtApplCancelConnectCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplCancelConnectCfmSignal >& signal);

   virtual void onBtApplStatusNotificationIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplStatusNotificationIndError >& error);

   virtual void onBtApplStatusNotificationIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplStatusNotificationIndSignal >& signal);

   virtual void onBtApplGetHwVersionCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionCfmError >& error);

   virtual void onBtApplGetHwVersionCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplGetHwVersionCfmSignal >& signal);

   virtual void onBtApplSetConfigurationCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationCfmError >& error);

   virtual void onBtApplSetConfigurationCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplSetConfigurationCfmSignal >& signal);

   virtual void onBtApplReadConfigurationCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationCfmError >& error);

   virtual void onBtApplReadConfigurationCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplReadConfigurationCfmSignal >& signal);

   virtual void onBtApplTestModeCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCfmError >& error);

   virtual void onBtApplTestModeCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCfmSignal >& signal);

   virtual void onBtApplTestModeCompIndError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCompIndError >& error);

   virtual void onBtApplTestModeCompIndSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeCompIndSignal >& signal);

   virtual void onBtApplTestModeLinkQualityCfmError(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityCfmError >& error);

   virtual void onBtApplTestModeLinkQualityCfmSignal(const ::boost::shared_ptr< DMProxy >& proxy, const ::boost::shared_ptr< BtApplTestModeLinkQualityCfmSignal >& signal);
   // org/alps/evo/DMProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusDMCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_DM_CALLBACK_IF_H_
