/**
 * @file ConnManDbusServiceCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan DBUS Callback Interface for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Callback Interface for Service.
 */

#ifndef _CONN_MAN_DBUS_SERVICE_CALLBACK_IF_H_
#define _CONN_MAN_DBUS_SERVICE_CALLBACK_IF_H_

#include "cc_dbus_if/IConnManDbusServiceCallbackIf.h"
#include "DbusCallbackIf.h"

#include "net/connman/ServiceProxy.h"

using namespace ::net::connman::Service;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class ConnManDbusServiceCallbackIf : public DbusCallbackIf, public ::ccdbusif::IConnManDbusServiceCallbackIf
{
public:
   ConnManDbusServiceCallbackIf(IDbusRecHandler* recHandler);
   virtual ~ConnManDbusServiceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // net/connman/ServiceProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onConnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error);

   virtual void onConnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response);

   virtual void onDisconnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error);

   virtual void onDisconnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);
   // net/connman/ServiceProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   ConnManDbusServiceCallbackIf();
};

} //genivi
} //btstackif

#endif //_CONN_MAN_DBUS_SERVICE_CALLBACK_IF_H_
