/**
 * @file EvolutionGeniviAgentFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Agent.
 */

#include "EvolutionGeniviAgentFactory.h"
#include "EvolutionGeniviAgentCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviAgentFactory::EvolutionGeniviAgentFactory() :
_createdLocally(true),
_cb(0)
{
}

EvolutionGeniviAgentFactory::~EvolutionGeniviAgentFactory()
{
   _cb = 0;
}

EvolutionGeniviAgentFactory& EvolutionGeniviAgentFactory::getInstance(void)
{
   static EvolutionGeniviAgentFactory factory;
   return factory;
}

IEvolutionGeniviAgentCallbackIf* EvolutionGeniviAgentFactory::getCb(IDbusRecHandler* handler)
{
   if(0 != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviAgentCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviAgentFactory::destroyCb(void)
{
   if((0 != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = 0;
   }
}

void EvolutionGeniviAgentFactory::setCbForTesting(IEvolutionGeniviAgentCallbackIf* testCallback)
{
   if(0 != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
