/**
 * @file IEvolutionGeniviSerialCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Serial.
 */

#ifndef _I_EVOLUTION_GENIVI_SERIAL_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_SERIAL_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusSerialCallbackIf.h"

using namespace ::org::bluez::Serial;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 * Callback interface class for Serial.
 */
class IEvolutionGeniviSerialCallbackIf : public ::ccdbusif::IEvolutionGeniviDbusSerialCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviSerialCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // /org/bluez/SerialProxy implementation --- start
   virtual void onSendDataErrorCb(const ::boost::shared_ptr< SendDataError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSendDataResponseCb(const ::boost::shared_ptr< SendDataResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSppDataIndErrorCb(const ::boost::shared_ptr< SppDataIndError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSppDataIndSignalCb(const ::boost::shared_ptr< SppDataIndSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onFlowCtrlSendErrorCb(const ::boost::shared_ptr< FlowCtrlSendError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onFlowCtrlSendSignalCb(const ::boost::shared_ptr< FlowCtrlSendSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onDeviceFilePathErrorCb(const ::boost::shared_ptr< DeviceFilePathError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onDeviceFilePathSignalCb(const ::boost::shared_ptr< DeviceFilePathSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onFlowCtrlRecvErrorCb(const ::boost::shared_ptr< FlowCtrlRecvError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onFlowCtrlRecvUpdateCb(const ::boost::shared_ptr< FlowCtrlRecvUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // /org/bluez/SerialProxy implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;
};

} //genivi
} //btstackif

#endif //_I_EVOLUTION_GENIVI_SERIAL_CALLBACK_IF_H_
