/**
 * @file EvolutionGeniviAgentFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Agent.
 */

#ifndef _EVOLUTION_GENIVI_AGENT_FACTORY_H_
#define _EVOLUTION_GENIVI_AGENT_FACTORY_H_

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class IEvolutionGeniviAgentCallbackIf;

/**
 * Factory class for EvolutionGeniviAgent.
 */
class EvolutionGeniviAgentFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviAgentFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   IEvolutionGeniviAgentCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(IEvolutionGeniviAgentCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviAgentFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviAgentFactory();

   bool _createdLocally; /**< creator flag */
   IEvolutionGeniviAgentCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_AGENT_FACTORY_H_
