/**
 * @file EvolutionGeniviAdapterCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback for Adapter.
 */

#ifndef _EVOLUTION_GENIVI_ADAPTER_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_ADAPTER_CALLBACK_IF_H_

#include "IEvolutionGeniviAdapterCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::org::bluez::Adapter1;

namespace btstackif {
namespace genivi {

/**
 * Callback class for Adapter.
 */
class EvolutionGeniviAdapterCallbackIf : public DbusCallbackIf, public IEvolutionGeniviAdapterCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   EvolutionGeniviAdapterCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~EvolutionGeniviAdapterCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);
   // "ServiceAvailableIF" implementation --- end

   // /org/bluez/Adapter1Proxy implementation --- start
   virtual void onStartDiscoveryErrorCb(const ::boost::shared_ptr< StartDiscoveryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onStartDiscoveryResponseCb(const ::boost::shared_ptr< StartDiscoveryResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onStopDiscoveryErrorCb(const ::boost::shared_ptr< StopDiscoveryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onStopDiscoveryResponseCb(const ::boost::shared_ptr< StopDiscoveryResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onRemoveDeviceErrorCb(const ::boost::shared_ptr< RemoveDeviceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onRemoveDeviceResponseCb(const ::boost::shared_ptr< RemoveDeviceResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onCreateDeviceErrorCb(const ::boost::shared_ptr< CreateDeviceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onCreateDeviceResponseCb(const ::boost::shared_ptr< CreateDeviceResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSendHCICmdErrorCb(const ::boost::shared_ptr< SendHCICmdError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSendHCICmdResponseCb(const ::boost::shared_ptr< SendHCICmdResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAdapterInitializationErrorCb(const ::boost::shared_ptr< AdapterInitializationError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAdapterInitializationSignalCb(const ::boost::shared_ptr< AdapterInitializationSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceCreatedErrorCb(const ::boost::shared_ptr< DeviceCreatedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceCreatedSignalCb(const ::boost::shared_ptr< DeviceCreatedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceRemovedErrorCb(const ::boost::shared_ptr< DeviceRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceRemovedSignalCb(const ::boost::shared_ptr< DeviceRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onBtStackLogErrorCb(const ::boost::shared_ptr< BtStackLogError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onBtStackLogSignalCb(const ::boost::shared_ptr< BtStackLogSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIEventErrorCb(const ::boost::shared_ptr< HCIEventError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIEventSignalCb(const ::boost::shared_ptr< HCIEventSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFoundErrorCb(const ::boost::shared_ptr< DeviceFoundError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFoundSignalCb(const ::boost::shared_ptr< DeviceFoundSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAddressErrorCb(const ::boost::shared_ptr< AddressError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAddressUpdateCb(const ::boost::shared_ptr< AddressUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onClassErrorCb(const ::boost::shared_ptr< ClassError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onClassUpdateCb(const ::boost::shared_ptr< ClassUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAliasErrorCb(const ::boost::shared_ptr< AliasError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAliasUpdateCb(const ::boost::shared_ptr< AliasUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPoweredErrorCb(const ::boost::shared_ptr< PoweredError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPoweredUpdateCb(const ::boost::shared_ptr< PoweredUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableErrorCb(const ::boost::shared_ptr< DiscoverableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableUpdateCb(const ::boost::shared_ptr< DiscoverableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableTimeoutErrorCb(const ::boost::shared_ptr< DiscoverableTimeoutError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableTimeoutUpdateCb(const ::boost::shared_ptr< DiscoverableTimeoutUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableErrorCb(const ::boost::shared_ptr< PairableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableUpdateCb(const ::boost::shared_ptr< PairableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableTimeoutErrorCb(const ::boost::shared_ptr< PairableTimeoutError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableTimeoutUpdateCb(const ::boost::shared_ptr< PairableTimeoutUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoveringErrorCb(const ::boost::shared_ptr< DiscoveringError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoveringUpdateCb(const ::boost::shared_ptr< DiscoveringUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onUUIDsErrorCb(const ::boost::shared_ptr< UUIDsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onUUIDsUpdateCb(const ::boost::shared_ptr< UUIDsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWBSModeErrorCb(const ::boost::shared_ptr< WBSModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWBSModeUpdateCb(const ::boost::shared_ptr< WBSModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConnectableErrorCb(const ::boost::shared_ptr< ConnectableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConnectableUpdateCb(const ::boost::shared_ptr< ConnectableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIModeErrorCb(const ::boost::shared_ptr< HCIModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIModeUpdateCb(const ::boost::shared_ptr< HCIModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onVersionErrorCb(const ::boost::shared_ptr< VersionError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onVersionUpdateCb(const ::boost::shared_ptr< VersionUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceLevelErrorCb(const ::boost::shared_ptr< TraceLevelError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceLevelUpdateCb(const ::boost::shared_ptr< TraceLevelUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceCategoryErrorCb(const ::boost::shared_ptr< TraceCategoryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceCategoryUpdateCb(const ::boost::shared_ptr< TraceCategoryUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAvailableSPPServersErrorCb(const ::boost::shared_ptr< AvailableSPPServersError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAvailableSPPServersUpdateCb(const ::boost::shared_ptr< AvailableSPPServersUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // /org/bluez/Adapter1Proxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

private:
   unsigned int _callbackId; /**< callback id */
};

/**
 * inline methods
 */
inline void EvolutionGeniviAdapterCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void EvolutionGeniviAdapterCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int EvolutionGeniviAdapterCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_ADAPTER_CALLBACK_IF_H_
