/**
 * @file ConnectionOrgFreedesktopObjectManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop DBUS Callback for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop DBUS Callback for ObjectManager.
 */

#ifndef _CONNECTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
#define _CONNECTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_

#include "IConnectionOrgFreedesktopObjectManagerCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

namespace btstackif {
namespace genivi {

/**
 * Callback class for ObjectManager.
 */
class ConnectionOrgFreedesktopObjectManagerCallbackIf : public DbusCallbackIf, public IConnectionOrgFreedesktopObjectManagerCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   ConnectionOrgFreedesktopObjectManagerCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~ConnectionOrgFreedesktopObjectManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);
   // "ServiceAvailableIF" implementation --- end

   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

   virtual void setDeviceSendIf(::ccdbusif::IEvolutionGeniviDbusDeviceSendRequestIf* deviceSendIf);

   virtual void setServiceSendIf(::ccdbusif::IEvolutionGeniviDbusServiceSendRequestIf* serviceSendIf);

   virtual void setSerialSendIf(::ccdbusif::IEvolutionGeniviDbusSerialSendRequestIf* serialSendIf);

   virtual void setSerialCb(IEvolutionGeniviSerialCallbackIf* serialCb);

   virtual void setSimulateRequestConfirmation(const bool enable);

private:
   unsigned int _callbackId; /**< callback id */
   ::ccdbusif::IEvolutionGeniviDbusDeviceSendRequestIf* _deviceSendIf; /**< device handler */
   ::ccdbusif::IEvolutionGeniviDbusServiceSendRequestIf* _serviceSendIf; /**< service handler */
   ::ccdbusif::IEvolutionGeniviDbusSerialSendRequestIf* _serialSendIf; /**< serial handler */
   IEvolutionGeniviSerialCallbackIf* _serialCb; /**< serial callback */
   bool _simulateRequestConfirmation; /**< simulation flag */
};

/**
 * inline methods
 */
inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int ConnectionOrgFreedesktopObjectManagerCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setDeviceSendIf(::ccdbusif::IEvolutionGeniviDbusDeviceSendRequestIf* deviceSendIf)
{
   _deviceSendIf = deviceSendIf;
}

inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setServiceSendIf(::ccdbusif::IEvolutionGeniviDbusServiceSendRequestIf* serviceSendIf)
{
   _serviceSendIf = serviceSendIf;
}

inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setSerialSendIf(::ccdbusif::IEvolutionGeniviDbusSerialSendRequestIf* serialSendIf)
{
   _serialSendIf = serialSendIf;
}

inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setSerialCb(IEvolutionGeniviSerialCallbackIf* serialCb)
{
   _serialCb = serialCb;
}

inline void ConnectionOrgFreedesktopObjectManagerCallbackIf::setSimulateRequestConfirmation(const bool enable)
{
   _simulateRequestConfirmation = enable;
}

} //genivi
} //btstackif

#endif //_CONNECTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
