/**
 * @file ConnectionControlAlpsEvolutionExt.cpp
 *
 * @par SW-Component
 * Connection Control
 *
 * @brief Implementation of connection control functionality for Alps Evolution Genivi extensions.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of connection control functionality for Alps Evolution Genivi extensions.
 */

#include "ConnectionControl_GEN.h"
#include "IConnectionSmExtension.h"
#include "FwAssert.h"
#include "AlpsEvolutionConnectionControl.h"
#include "BasicConfigurationAlpsEvolutionExt.h"
#include "SppConnectDisconnectAlpsEvolutionExt.h"
#include "DeviceIdServiceRecordAlpsEvolutionExt.h"
#include "BluetoothStackErrorHandlingAlpsEvolutionExt.h"

namespace btstackif {
namespace genivi {

void ConnectionControl::initializeAlpsEvolutionGeniviSMs(void)
{
   // create extension
   if(0 == _smExtension)
   {
      alpsevolutionext::AlpsEvolutionConnectionControl* extension = new alpsevolutionext::AlpsEvolutionConnectionControl();
      _smExtension = extension;
      _extensions.push_back(extension);
      if(0 != extension)
      {
         extension->enable(true);
      }
   }
   FW_NORMAL_ASSERT(0 != _smExtension);

   if(0 == _alpsEvolutionExtBasicConfiguration)
   {
      _alpsEvolutionExtBasicConfiguration = new alpsevolutionext::BasicConfigurationAlpsEvolutionExt();
   }
   FW_NORMAL_ASSERT(0 != _alpsEvolutionExtBasicConfiguration);

   if(0 == _alpsEvolutionExtSppConnectDisconnect)
   {
      _alpsEvolutionExtSppConnectDisconnect = new alpsevolutionext::SppConnectDisconnectAlpsEvolutionExt();
   }
   FW_NORMAL_ASSERT(0 != _alpsEvolutionExtSppConnectDisconnect);

   if(0 == _alpsEvolutionExtDeviceIdServiceRecord)
   {
      _alpsEvolutionExtDeviceIdServiceRecord = new alpsevolutionext::DeviceIdServiceRecordAlpsEvolutionExt();
   }
   FW_NORMAL_ASSERT(0 != _alpsEvolutionExtDeviceIdServiceRecord);

   if(0 == _alpsEvolutionExtBluetoothStackErrorHandling)
   {
      _alpsEvolutionExtBluetoothStackErrorHandling = new alpsevolutionext::BluetoothStackErrorHandlingAlpsEvolutionExt();
   }
   FW_NORMAL_ASSERT(0 != _alpsEvolutionExtBluetoothStackErrorHandling);
}

void ConnectionControl::destroyAlpsEvolutionGeniviSMs(void)
{
   // release extensions
   FW_IF_NULL_PTR_RETURN(_smExtension);

   // delete of _smExtension is done outside
   _smExtension = 0;

   if(0 != _alpsEvolutionExtBasicConfiguration)
   {
      delete _alpsEvolutionExtBasicConfiguration;
      _alpsEvolutionExtBasicConfiguration = 0;
   }

   if(0 != _alpsEvolutionExtSppConnectDisconnect)
   {
      delete _alpsEvolutionExtSppConnectDisconnect;
      _alpsEvolutionExtSppConnectDisconnect = 0;
   }

   if(0 != _alpsEvolutionExtDeviceIdServiceRecord)
   {
      delete _alpsEvolutionExtDeviceIdServiceRecord;
      _alpsEvolutionExtDeviceIdServiceRecord = 0;
   }

   if(0 != _alpsEvolutionExtBluetoothStackErrorHandling)
   {
      delete _alpsEvolutionExtBluetoothStackErrorHandling;
      _alpsEvolutionExtBluetoothStackErrorHandling = 0;
   }
}

} //genivi
} //btstackif
