/**
 * @file PhonebookControl_GEN.h
 *
 * @par SW-Component
 * Main
 *
 * @brief Phonebook Control.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for phonebook control functionality.
 */

#ifndef _PHONEBOOK_CONTROL_GENIVI_H_
#define _PHONEBOOK_CONTROL_GENIVI_H_

#include "BtStackInternalTypes.h"
#include "BasicControl.h"
#include "DbusServiceAvailability.h"

/*********** start here with specific includes ********************************/
/*********** end here with specific includes **********************************/

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
// App2Bts messages
class App2Bts_SetPhonebookDummy;

namespace genivi {

// class forward declarations
// Ipc2Bts messages
class Ipc2Bts_ServiceAvailabilityPhonebook;
class Ipc2Bts_PimSessionSourceUpdate;
class Ipc2Bts_PimSessionDestinationUpdate;
class Ipc2Bts_PimSessionChannelUpdate;
class Ipc2Bts_PimSessionTargetUpdate;
class Ipc2Bts_PimTransferCancelResult;
class Ipc2Bts_PimTransferStatusUpdate;
class Ipc2Bts_PimTransferSessionUpdate;
class Ipc2Bts_PimTransferNameUpdate;
class Ipc2Bts_PimTransferTypeUpdate;
class Ipc2Bts_PimTransferTimeUpdate;
class Ipc2Bts_PimTransferSizeUpdate;
class Ipc2Bts_PimTransferTransferredUpdate;
class Ipc2Bts_PimTransferFilenameUpdate;

/**
 *
 */
class PhonebookControl : public BasicControl
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   PhonebookControl();

   /**
    * Destructor.
    */
   virtual ~PhonebookControl();

   virtual void pushApp2BtsMessage(IN App2Bts_BaseMessage* ptrMessage);

   virtual void pushIpc2BtsMessage(IN Ipc2Bts_BaseMessage* ptrMessage);

   virtual void setStackConfiguration(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode,
         OUT ::std::vector<BTSDbusInterfaceItem>& dbusInterfaces, IN const BTSLocalConfigurationContainer& configuration);

   virtual void triggerInitializedCallback(void);

   virtual void createDbusServiceAvailabilityMessage(IN const BTSCommonEnumClass interface, IN const BTSDbusServiceAvailability availabilityEvent);

   virtual void createDbusServiceAvailabilityMessage(IN const BTSCommonEnumClass interface, IN const BTSDbusServiceAvailability availabilityEvent, IN const BTSBusName& busName, IN const BTSObjectPath& objPath, IN const BTSCommonEnumClass busType);

   virtual void setSubControlTestCommand(IN const char* testCommand, IN const unsigned int testData);

   virtual void setSubControlTestCommand(IN const char* testCommand, IN const unsigned char* testData);

   virtual void sendDirectAnswerForApp2BtsMessages(IN const ::std::vector<App2Bts_BaseMessage*>& msgList, IN const BTSCommonEnumClass resultCode, IN const BTSCommonEnumClass statusCode); // TODO: later do a merge of handleDoubledApp2BtsMessages and sendDirectAnswerForApp2BtsMessages; rename also all handleDoubledApp2BtsXxx

protected:
   virtual bool doApp2BtsMsgPrecheck(OUT bool& rejectRequest, OUT BTSCommonEnumClass& resultCode, OUT BTSCommonEnumClass& statusCode, OUT bool& skipOpCodeCheck, IN App2Bts_BaseMessage* ptrMessage);

   virtual void getSimilarOpCodes(OUT ::std::vector<BTSApp2BtsMessageMasterCompareItem>& itemList, IN const App2Bts_BaseMessage* ptrMessage);

   virtual void getMatchingOpCodes(OUT ::std::vector<BTSApp2BtsMessageMasterCompareItem>& itemList, OUT ::std::vector<BTSApp2BtsMessageMasterCompareItem>& highPrioItemList, IN const App2Bts_BaseMessage* ptrMessage);

   virtual bool skipSimilarOpCodeCheck(IN const App2Bts_BaseMessage* ptrMessage);

   virtual void checkWaitingQueueExtended(IN const BTSApp2BtsMessageCompareItem& compareItem);

   virtual void handleDoubledApp2BtsMessages(IN const ::std::vector<App2Bts_BaseMessage*>& msgList);

private:
   /*********** start here with specific class members + methods *****************/
   /*********** end here with specific class members + methods *******************/

   /**
    * Handle doubled App2Bts message.
    * Handle any error within this function.
    *
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[in] ptrMessage: received App2Bts message
    * @param[in] resultCode: result code
    * @param[in] statusCode: status code
    */
   void handleDoubledApp2BtsSetPhonebookDummy(OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, IN App2Bts_SetPhonebookDummy* ptrMessage, IN const BTSCommonEnumClass resultCode, IN const BTSCommonEnumClass statusCode);

   /**
    * Handle received App2Bts message.
    * Handle any error within this function.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] deleteApp2BtsMessage: marker to delete related App2Bts message
    * @param[in] ptrMessage: received App2Bts message
    */
   void handleApp2BtsSetPhonebookDummy(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT bool& deleteApp2BtsMessage, IN App2Bts_SetPhonebookDummy* ptrMessage);

   /**
    * Handle received Ipc2Bts message.
    * Handle any error within this function.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] compareItem: compare item for special handling
    * @param[out] deleteApp2BtsMessage: marker to delete related App2Bts message; in case of a DBUS message sequence has to be passed we have to delete the related App2Bts message after sequence is finished
    * @param[in,out] app2BtsMessage: related App2Bts message from working queue
    * @param[in] ptrMessage: received Ipc2Bts message
    */
   void handleIpc2BtsServiceAvailabilityPhonebook(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_ServiceAvailabilityPhonebook* ptrMessage);
   void handleIpc2BtsPimSessionSourceUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimSessionSourceUpdate* ptrMessage);
   void handleIpc2BtsPimSessionDestinationUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimSessionDestinationUpdate* ptrMessage);
   void handleIpc2BtsPimSessionChannelUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimSessionChannelUpdate* ptrMessage);
   void handleIpc2BtsPimSessionTargetUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimSessionTargetUpdate* ptrMessage);
   void handleIpc2BtsPimTransferCancelResult(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferCancelResult* ptrMessage);
   void handleIpc2BtsPimTransferStatusUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferStatusUpdate* ptrMessage);
   void handleIpc2BtsPimTransferSessionUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferSessionUpdate* ptrMessage);
   void handleIpc2BtsPimTransferNameUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferNameUpdate* ptrMessage);
   void handleIpc2BtsPimTransferTypeUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferTypeUpdate* ptrMessage);
   void handleIpc2BtsPimTransferTimeUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferTimeUpdate* ptrMessage);
   void handleIpc2BtsPimTransferSizeUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferSizeUpdate* ptrMessage);
   void handleIpc2BtsPimTransferTransferredUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferTransferredUpdate* ptrMessage);
   void handleIpc2BtsPimTransferFilenameUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSApp2BtsMessageCompareItem& compareItem, OUT bool& deleteApp2BtsMessage, INOUT App2Bts_BaseMessage** app2BtsMessage, IN Ipc2Bts_PimTransferFilenameUpdate* ptrMessage);
};

} //genivi
} //btstackif

#endif //_PHONEBOOK_CONTROL_GENIVI_H_
