/**
 * @file EvolutionGeniviStackOpcodesTrace.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace enum to string.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace enum to string.
 * This file is completely generated by parser tooling (code generation). => DO NOT EDIT!
 */

#include "EvolutionGeniviStackOpcodesTrace.h"

namespace btstackif {
namespace genivi {

const char* getGenBts2IpcOpcode2String(BTSGenBts2IpcOpcode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case Bts2IpcOC_None:
         result = "None";
         break;
      case Bts2IpcOC_ConnectionBlockStart:
         result = "ConnectionBlockStart";
         break;
      case Bts2IpcOC_GetManagedObjectsConnection:
         result = "GetManagedObjectsConnection";
         break;
      case Bts2IpcOC_GetAllPropertiesConnection:
         result = "GetAllPropertiesConnection";
         break;
      case Bts2IpcOC_GetIntrospectionConnection:
         result = "GetIntrospectionConnection";
         break;
      case Bts2IpcOC_ReleaseRes:
         result = "ReleaseRes";
         break;
      case Bts2IpcOC_RequestPinCodeRes:
         result = "RequestPinCodeRes";
         break;
      case Bts2IpcOC_DisplayPinCodeRes:
         result = "DisplayPinCodeRes";
         break;
      case Bts2IpcOC_RequestPasskeyRes:
         result = "RequestPasskeyRes";
         break;
      case Bts2IpcOC_RequestConfirmationRes:
         result = "RequestConfirmationRes";
         break;
      case Bts2IpcOC_CancelRes:
         result = "CancelRes";
         break;
      case Bts2IpcOC_CancelRequestRes:
         result = "CancelRequestRes";
         break;
      case Bts2IpcOC_AuthorizeServiceRes:
         result = "AuthorizeServiceRes";
         break;
      case Bts2IpcOC_RequestAuthorizationRes:
         result = "RequestAuthorizationRes";
         break;
      case Bts2IpcOC_RequestLinkkeyRes:
         result = "RequestLinkkeyRes";
         break;
      case Bts2IpcOC_DisplayPasskeyRes:
         result = "DisplayPasskeyRes";
         break;
      case Bts2IpcOC_StartDiscovery:
         result = "StartDiscovery";
         break;
      case Bts2IpcOC_StopDiscovery:
         result = "StopDiscovery";
         break;
      case Bts2IpcOC_RemoveDevice:
         result = "RemoveDevice";
         break;
      case Bts2IpcOC_CreateDevice:
         result = "CreateDevice";
         break;
      case Bts2IpcOC_SendHCICmd:
         result = "SendHCICmd";
         break;
      case Bts2IpcOC_GetAdapterAddress:
         result = "GetAdapterAddress";
         break;
      case Bts2IpcOC_GetAdapterClass:
         result = "GetAdapterClass";
         break;
      case Bts2IpcOC_GetAdapterAlias:
         result = "GetAdapterAlias";
         break;
      case Bts2IpcOC_SetAdapterAlias:
         result = "SetAdapterAlias";
         break;
      case Bts2IpcOC_GetAdapterPowered:
         result = "GetAdapterPowered";
         break;
      case Bts2IpcOC_SetAdapterPowered:
         result = "SetAdapterPowered";
         break;
      case Bts2IpcOC_GetAdapterDiscoverable:
         result = "GetAdapterDiscoverable";
         break;
      case Bts2IpcOC_SetAdapterDiscoverable:
         result = "SetAdapterDiscoverable";
         break;
      case Bts2IpcOC_GetAdapterDiscoverabletimeout:
         result = "GetAdapterDiscoverabletimeout";
         break;
      case Bts2IpcOC_SetAdapterDiscoverabletimeout:
         result = "SetAdapterDiscoverabletimeout";
         break;
      case Bts2IpcOC_GetAdapterPairable:
         result = "GetAdapterPairable";
         break;
      case Bts2IpcOC_SetAdapterPairable:
         result = "SetAdapterPairable";
         break;
      case Bts2IpcOC_GetAdapterPairabletimeout:
         result = "GetAdapterPairabletimeout";
         break;
      case Bts2IpcOC_SetAdapterPairabletimeout:
         result = "SetAdapterPairabletimeout";
         break;
      case Bts2IpcOC_GetAdapterDiscovering:
         result = "GetAdapterDiscovering";
         break;
      case Bts2IpcOC_GetAdapterUuids:
         result = "GetAdapterUuids";
         break;
      case Bts2IpcOC_SetAdapterUuids:
         result = "SetAdapterUuids";
         break;
      case Bts2IpcOC_GetAdapterWbsMode:
         result = "GetAdapterWbsMode";
         break;
      case Bts2IpcOC_SetAdapterWbsMode:
         result = "SetAdapterWbsMode";
         break;
      case Bts2IpcOC_GetAdapterConnectable:
         result = "GetAdapterConnectable";
         break;
      case Bts2IpcOC_SetAdapterConnectable:
         result = "SetAdapterConnectable";
         break;
      case Bts2IpcOC_GetAdapterHcimode:
         result = "GetAdapterHcimode";
         break;
      case Bts2IpcOC_SetAdapterHcimode:
         result = "SetAdapterHcimode";
         break;
      case Bts2IpcOC_GetAdapterVersion:
         result = "GetAdapterVersion";
         break;
      case Bts2IpcOC_GetAdapterTraceLevel:
         result = "GetAdapterTraceLevel";
         break;
      case Bts2IpcOC_SetAdapterTraceLevel:
         result = "SetAdapterTraceLevel";
         break;
      case Bts2IpcOC_GetAdapterTraceCategory:
         result = "GetAdapterTraceCategory";
         break;
      case Bts2IpcOC_SetAdapterTraceCategory:
         result = "SetAdapterTraceCategory";
         break;
      case Bts2IpcOC_GetAdapterAvailableSppServers:
         result = "GetAdapterAvailableSppServers";
         break;
      case Bts2IpcOC_SetAdapterAvailableSppServers:
         result = "SetAdapterAvailableSppServers";
         break;
      case Bts2IpcOC_RegisterAgent:
         result = "RegisterAgent";
         break;
      case Bts2IpcOC_UnregisterAgent:
         result = "UnregisterAgent";
         break;
      case Bts2IpcOC_RequestDefaultAgent:
         result = "RequestDefaultAgent";
         break;
      case Bts2IpcOC_DeviceConnect:
         result = "DeviceConnect";
         break;
      case Bts2IpcOC_DeviceDisconnect:
         result = "DeviceDisconnect";
         break;
      case Bts2IpcOC_Pair:
         result = "Pair";
         break;
      case Bts2IpcOC_CancelPairing:
         result = "CancelPairing";
         break;
      case Bts2IpcOC_DiscoverServices:
         result = "DiscoverServices";
         break;
      case Bts2IpcOC_CancelDiscovery:
         result = "CancelDiscovery";
         break;
      case Bts2IpcOC_GetDeviceAddress:
         result = "GetDeviceAddress";
         break;
      case Bts2IpcOC_GetDeviceClass:
         result = "GetDeviceClass";
         break;
      case Bts2IpcOC_GetDeviceIcon:
         result = "GetDeviceIcon";
         break;
      case Bts2IpcOC_GetDeviceUuids:
         result = "GetDeviceUuids";
         break;
      case Bts2IpcOC_GetDevicePaired:
         result = "GetDevicePaired";
         break;
      case Bts2IpcOC_GetDeviceConnected:
         result = "GetDeviceConnected";
         break;
      case Bts2IpcOC_GetDeviceTrusted:
         result = "GetDeviceTrusted";
         break;
      case Bts2IpcOC_SetDeviceTrusted:
         result = "SetDeviceTrusted";
         break;
      case Bts2IpcOC_GetDeviceBlocked:
         result = "GetDeviceBlocked";
         break;
      case Bts2IpcOC_SetDeviceBlocked:
         result = "SetDeviceBlocked";
         break;
      case Bts2IpcOC_GetDeviceAlias:
         result = "GetDeviceAlias";
         break;
      case Bts2IpcOC_SetDeviceAlias:
         result = "SetDeviceAlias";
         break;
      case Bts2IpcOC_GetDeviceAdapter:
         result = "GetDeviceAdapter";
         break;
      case Bts2IpcOC_GetDeviceModalias:
         result = "GetDeviceModalias";
         break;
      case Bts2IpcOC_GetDeviceRssi:
         result = "GetDeviceRssi";
         break;
      case Bts2IpcOC_GetDeviceVendorId:
         result = "GetDeviceVendorId";
         break;
      case Bts2IpcOC_GetDeviceVendorIdSource:
         result = "GetDeviceVendorIdSource";
         break;
      case Bts2IpcOC_GetDeviceProductId:
         result = "GetDeviceProductId";
         break;
      case Bts2IpcOC_GetDeviceMapInfo:
         result = "GetDeviceMapInfo";
         break;
      case Bts2IpcOC_GetDeviceConnectedService:
         result = "GetDeviceConnectedService";
         break;
      case Bts2IpcOC_GetDeviceVersion:
         result = "GetDeviceVersion";
         break;
      case Bts2IpcOC_GetDevicePbapInfo:
         result = "GetDevicePbapInfo";
         break;
      case Bts2IpcOC_GetDeviceMode:
         result = "GetDeviceMode";
         break;
      case Bts2IpcOC_GetDeviceRole:
         result = "GetDeviceRole";
         break;
      case Bts2IpcOC_GetDeviceEnableAvpPause:
         result = "GetDeviceEnableAvpPause";
         break;
      case Bts2IpcOC_SetDeviceEnableAvpPause:
         result = "SetDeviceEnableAvpPause";
         break;
      case Bts2IpcOC_BtApplDeviceConnectReq:
         result = "BtApplDeviceConnectReq";
         break;
      case Bts2IpcOC_BtApplDeviceDisconnectReq:
         result = "BtApplDeviceDisconnectReq";
         break;
      case Bts2IpcOC_BtApplCancelConnectReq:
         result = "BtApplCancelConnectReq";
         break;
      case Bts2IpcOC_BtApplGetHwVersionReq:
         result = "BtApplGetHwVersionReq";
         break;
      case Bts2IpcOC_BtApplSetConfigurationReq:
         result = "BtApplSetConfigurationReq";
         break;
      case Bts2IpcOC_BtApplReadConfigurationReq:
         result = "BtApplReadConfigurationReq";
         break;
      case Bts2IpcOC_BtApplTestModeReq:
         result = "BtApplTestModeReq";
         break;
      case Bts2IpcOC_BtApplTestModeLinkQualityReq:
         result = "BtApplTestModeLinkQualityReq";
         break;
      case Bts2IpcOC_Connect:
         result = "Connect";
         break;
      case Bts2IpcOC_Disconnect:
         result = "Disconnect";
         break;
      case Bts2IpcOC_GetServiceRemoteUuid:
         result = "GetServiceRemoteUuid";
         break;
      case Bts2IpcOC_GetServiceState:
         result = "GetServiceState";
         break;
      case Bts2IpcOC_GetServiceDevice:
         result = "GetServiceDevice";
         break;
      case Bts2IpcOC_GetServiceVersion:
         result = "GetServiceVersion";
         break;
      case Bts2IpcOC_DebugTraceConfig:
         result = "DebugTraceConfig";
         break;
      case Bts2IpcOC_ProtocolTraceConfig:
         result = "ProtocolTraceConfig";
         break;
      case Bts2IpcOC_BtApplDidSetReq:
         result = "BtApplDidSetReq";
         break;
      case Bts2IpcOC_GetDunDeviceFilePath:
         result = "GetDunDeviceFilePath";
         break;
      case Bts2IpcOC_BtApplSppSetUuidReq:
         result = "BtApplSppSetUuidReq";
         break;
      case Bts2IpcOC_CreateSession:
         result = "CreateSession";
         break;
      case Bts2IpcOC_RemoveSession:
         result = "RemoveSession";
         break;
      case Bts2IpcOC_CancelSession:
         result = "CancelSession";
         break;
      case Bts2IpcOC_GetConnManManagerProperties:
         result = "GetConnManManagerProperties";
         break;
      case Bts2IpcOC_GetConnManTechnologies:
         result = "GetConnManTechnologies";
         break;
      case Bts2IpcOC_GetConnManServices:
         result = "GetConnManServices";
         break;
      case Bts2IpcOC_GetConnManServiceProperties:
         result = "GetConnManServiceProperties";
         break;
      case Bts2IpcOC_ConnManServiceConnect:
         result = "ConnManServiceConnect";
         break;
      case Bts2IpcOC_ConnManServiceDisconnect:
         result = "ConnManServiceDisconnect";
         break;
      case Bts2IpcOC_CreateLeDevice:
         result = "CreateLeDevice";
         break;
      case Bts2IpcOC_RemoveLeDevice:
         result = "RemoveLeDevice";
         break;
      case Bts2IpcOC_GetLeAdapterAddressType:
         result = "GetLeAdapterAddressType";
         break;
      case Bts2IpcOC_GetLeAdapterAddress:
         result = "GetLeAdapterAddress";
         break;
      case Bts2IpcOC_GetLeAdapterAlias:
         result = "GetLeAdapterAlias";
         break;
      case Bts2IpcOC_SetLeAdapterAlias:
         result = "SetLeAdapterAlias";
         break;
      case Bts2IpcOC_GetLeAdapterAdvertisingTimeout:
         result = "GetLeAdapterAdvertisingTimeout";
         break;
      case Bts2IpcOC_SetLeAdapterAdvertisingTimeout:
         result = "SetLeAdapterAdvertisingTimeout";
         break;
      case Bts2IpcOC_GetLeAdapterDiscoverableMode:
         result = "GetLeAdapterDiscoverableMode";
         break;
      case Bts2IpcOC_SetLeAdapterDiscoverableMode:
         result = "SetLeAdapterDiscoverableMode";
         break;
      case Bts2IpcOC_GetLeAdapterAdvertisingData:
         result = "GetLeAdapterAdvertisingData";
         break;
      case Bts2IpcOC_SetLeAdapterAdvertisingData:
         result = "SetLeAdapterAdvertisingData";
         break;
      case Bts2IpcOC_GetLeAdapterAdvertiseEnable:
         result = "GetLeAdapterAdvertiseEnable";
         break;
      case Bts2IpcOC_SetLeAdapterAdvertiseEnable:
         result = "SetLeAdapterAdvertiseEnable";
         break;
      case Bts2IpcOC_LeDeviceDisconnect:
         result = "LeDeviceDisconnect";
         break;
      case Bts2IpcOC_GetLeDeviceAddressType:
         result = "GetLeDeviceAddressType";
         break;
      case Bts2IpcOC_GetLeDeviceAddress:
         result = "GetLeDeviceAddress";
         break;
      case Bts2IpcOC_GetLeDeviceConnected:
         result = "GetLeDeviceConnected";
         break;
      case Bts2IpcOC_SendSeamlessPairingErrorCode:
         result = "SendSeamlessPairingErrorCode";
         break;
      case Bts2IpcOC_SeamlessPairingAllowAccess:
         result = "SeamlessPairingAllowAccess";
         break;
      case Bts2IpcOC_GetSeamlessPairingPairingData:
         result = "GetSeamlessPairingPairingData";
         break;
      case Bts2IpcOC_SetSeamlessPairingPairingData:
         result = "SetSeamlessPairingPairingData";
         break;
      case Bts2IpcOC_ConnectionBlockEnd:
         result = "ConnectionBlockEnd";
         break;
      case Bts2IpcOC_TelephonyBlockStart:
         result = "TelephonyBlockStart";
         break;
      case Bts2IpcOC_GetManagedObjectsTelephony:
         result = "GetManagedObjectsTelephony";
         break;
      case Bts2IpcOC_GetAllPropertiesTelephony:
         result = "GetAllPropertiesTelephony";
         break;
      case Bts2IpcOC_GetIntrospectionTelephony:
         result = "GetIntrospectionTelephony";
         break;
      case Bts2IpcOC_GetHandsfreeProperties:
         result = "GetHandsfreeProperties";
         break;
      case Bts2IpcOC_GetModems:
         result = "GetModems";
         break;
      case Bts2IpcOC_GetModemProperties:
         result = "GetModemProperties";
         break;
      case Bts2IpcOC_TelephonyBlockEnd:
         result = "TelephonyBlockEnd";
         break;
      case Bts2IpcOC_PhonebookBlockStart:
         result = "PhonebookBlockStart";
         break;
      case Bts2IpcOC_GetManagedObjectsPhonebook:
         result = "GetManagedObjectsPhonebook";
         break;
      case Bts2IpcOC_GetAllPropertiesPhonebook:
         result = "GetAllPropertiesPhonebook";
         break;
      case Bts2IpcOC_GetIntrospectionPhonebook:
         result = "GetIntrospectionPhonebook";
         break;
      case Bts2IpcOC_GetPimSessionSource:
         result = "GetPimSessionSource";
         break;
      case Bts2IpcOC_GetPimSessionDestination:
         result = "GetPimSessionDestination";
         break;
      case Bts2IpcOC_GetPimSessionChannel:
         result = "GetPimSessionChannel";
         break;
      case Bts2IpcOC_GetPimSessionTarget:
         result = "GetPimSessionTarget";
         break;
      case Bts2IpcOC_PimTransferCancel:
         result = "PimTransferCancel";
         break;
      case Bts2IpcOC_GetPimTransferStatus:
         result = "GetPimTransferStatus";
         break;
      case Bts2IpcOC_GetPimTransferSession:
         result = "GetPimTransferSession";
         break;
      case Bts2IpcOC_GetPimTransferName:
         result = "GetPimTransferName";
         break;
      case Bts2IpcOC_GetPimTransferType:
         result = "GetPimTransferType";
         break;
      case Bts2IpcOC_GetPimTransferTime:
         result = "GetPimTransferTime";
         break;
      case Bts2IpcOC_GetPimTransferSize:
         result = "GetPimTransferSize";
         break;
      case Bts2IpcOC_GetPimTransferTransferred:
         result = "GetPimTransferTransferred";
         break;
      case Bts2IpcOC_GetPimTransferFilename:
         result = "GetPimTransferFilename";
         break;
      case Bts2IpcOC_PhonebookBlockEnd:
         result = "PhonebookBlockEnd";
         break;
      case Bts2IpcOC_MessagingBlockStart:
         result = "MessagingBlockStart";
         break;
      case Bts2IpcOC_GetManagedObjectsMessaging:
         result = "GetManagedObjectsMessaging";
         break;
      case Bts2IpcOC_GetAllPropertiesMessaging:
         result = "GetAllPropertiesMessaging";
         break;
      case Bts2IpcOC_GetIntrospectionMessaging:
         result = "GetIntrospectionMessaging";
         break;
      case Bts2IpcOC_GetMsgSessionSource:
         result = "GetMsgSessionSource";
         break;
      case Bts2IpcOC_GetMsgSessionDestination:
         result = "GetMsgSessionDestination";
         break;
      case Bts2IpcOC_GetMsgSessionChannel:
         result = "GetMsgSessionChannel";
         break;
      case Bts2IpcOC_GetMsgSessionTarget:
         result = "GetMsgSessionTarget";
         break;
      case Bts2IpcOC_MsgTransferCancel:
         result = "MsgTransferCancel";
         break;
      case Bts2IpcOC_GetMsgTransferStatus:
         result = "GetMsgTransferStatus";
         break;
      case Bts2IpcOC_GetMsgTransferSession:
         result = "GetMsgTransferSession";
         break;
      case Bts2IpcOC_GetMsgTransferName:
         result = "GetMsgTransferName";
         break;
      case Bts2IpcOC_GetMsgTransferType:
         result = "GetMsgTransferType";
         break;
      case Bts2IpcOC_GetMsgTransferTime:
         result = "GetMsgTransferTime";
         break;
      case Bts2IpcOC_GetMsgTransferSize:
         result = "GetMsgTransferSize";
         break;
      case Bts2IpcOC_GetMsgTransferTransferred:
         result = "GetMsgTransferTransferred";
         break;
      case Bts2IpcOC_GetMsgTransferFilename:
         result = "GetMsgTransferFilename";
         break;
      case Bts2IpcOC_MessagingBlockEnd:
         result = "MessagingBlockEnd";
         break;
      case Bts2IpcOC_MediaPlayerBlockStart:
         result = "MediaPlayerBlockStart";
         break;
      case Bts2IpcOC_GetManagedObjectsMediaPlayer:
         result = "GetManagedObjectsMediaPlayer";
         break;
      case Bts2IpcOC_GetAllPropertiesMediaPlayer:
         result = "GetAllPropertiesMediaPlayer";
         break;
      case Bts2IpcOC_GetIntrospectionMediaPlayer:
         result = "GetIntrospectionMediaPlayer";
         break;
      case Bts2IpcOC_MediaPlayerBlockEnd:
         result = "MediaPlayerBlockEnd";
         break;
      case Bts2IpcOC_Last:
         result = "Last";
         break;
      default:
         break;
   }

   return result;
}

const char* getGenIpc2BtsOpcode2String(BTSGenIpc2BtsOpcode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case Ipc2BtsOC_None:
         result = "None";
         break;
      case Ipc2BtsOC_ConnectionBlockStart:
         result = "ConnectionBlockStart";
         break;
      case Ipc2BtsOC_ServiceAvailabilityConnection:
         result = "ServiceAvailabilityConnection";
         break;
      case Ipc2BtsOC_GetAllPropertiesConnection:
         result = "GetAllPropertiesConnection";
         break;
      case Ipc2BtsOC_AddDeviceObjectPathMapping:
         result = "AddDeviceObjectPathMapping";
         break;
      case Ipc2BtsOC_DelDeviceObjectPathMapping:
         result = "DelDeviceObjectPathMapping";
         break;
      case Ipc2BtsOC_AddProtocolObjectPathMapping:
         result = "AddProtocolObjectPathMapping";
         break;
      case Ipc2BtsOC_DelProtocolObjectPathMapping:
         result = "DelProtocolObjectPathMapping";
         break;
      case Ipc2BtsOC_AddSerialObjectPathMapping:
         result = "AddSerialObjectPathMapping";
         break;
      case Ipc2BtsOC_DelSerialObjectPathMapping:
         result = "DelSerialObjectPathMapping";
         break;
      case Ipc2BtsOC_Release:
         result = "Release";
         break;
      case Ipc2BtsOC_RequestPinCode:
         result = "RequestPinCode";
         break;
      case Ipc2BtsOC_DisplayPinCode:
         result = "DisplayPinCode";
         break;
      case Ipc2BtsOC_RequestPasskey:
         result = "RequestPasskey";
         break;
      case Ipc2BtsOC_RequestConfirmation:
         result = "RequestConfirmation";
         break;
      case Ipc2BtsOC_Cancel:
         result = "Cancel";
         break;
      case Ipc2BtsOC_CancelRequest:
         result = "CancelRequest";
         break;
      case Ipc2BtsOC_AuthorizeService:
         result = "AuthorizeService";
         break;
      case Ipc2BtsOC_RequestAuthorization:
         result = "RequestAuthorization";
         break;
      case Ipc2BtsOC_RequestLinkkey:
         result = "RequestLinkkey";
         break;
      case Ipc2BtsOC_DisplayPasskey:
         result = "DisplayPasskey";
         break;
      case Ipc2BtsOC_StartDiscoveryResult:
         result = "StartDiscoveryResult";
         break;
      case Ipc2BtsOC_StopDiscoveryResult:
         result = "StopDiscoveryResult";
         break;
      case Ipc2BtsOC_RemoveDeviceResult:
         result = "RemoveDeviceResult";
         break;
      case Ipc2BtsOC_CreateDeviceResult:
         result = "CreateDeviceResult";
         break;
      case Ipc2BtsOC_SendHCICmdResult:
         result = "SendHCICmdResult";
         break;
      case Ipc2BtsOC_AdapterInitialization:
         result = "AdapterInitialization";
         break;
      case Ipc2BtsOC_DeviceCreated:
         result = "DeviceCreated";
         break;
      case Ipc2BtsOC_DeviceRemoved:
         result = "DeviceRemoved";
         break;
      case Ipc2BtsOC_BtStackLog:
         result = "BtStackLog";
         break;
      case Ipc2BtsOC_HCIEvent:
         result = "HCIEvent";
         break;
      case Ipc2BtsOC_DeviceFound:
         result = "DeviceFound";
         break;
      case Ipc2BtsOC_AdapterAddressUpdate:
         result = "AdapterAddressUpdate";
         break;
      case Ipc2BtsOC_AdapterClassUpdate:
         result = "AdapterClassUpdate";
         break;
      case Ipc2BtsOC_AdapterAliasUpdate:
         result = "AdapterAliasUpdate";
         break;
      case Ipc2BtsOC_AdapterPoweredUpdate:
         result = "AdapterPoweredUpdate";
         break;
      case Ipc2BtsOC_AdapterDiscoverableUpdate:
         result = "AdapterDiscoverableUpdate";
         break;
      case Ipc2BtsOC_AdapterDiscoverabletimeoutUpdate:
         result = "AdapterDiscoverabletimeoutUpdate";
         break;
      case Ipc2BtsOC_AdapterPairableUpdate:
         result = "AdapterPairableUpdate";
         break;
      case Ipc2BtsOC_AdapterPairabletimeoutUpdate:
         result = "AdapterPairabletimeoutUpdate";
         break;
      case Ipc2BtsOC_AdapterDiscoveringUpdate:
         result = "AdapterDiscoveringUpdate";
         break;
      case Ipc2BtsOC_AdapterUuidsUpdate:
         result = "AdapterUuidsUpdate";
         break;
      case Ipc2BtsOC_AdapterWbsModeUpdate:
         result = "AdapterWbsModeUpdate";
         break;
      case Ipc2BtsOC_AdapterConnectableUpdate:
         result = "AdapterConnectableUpdate";
         break;
      case Ipc2BtsOC_AdapterHcimodeUpdate:
         result = "AdapterHcimodeUpdate";
         break;
      case Ipc2BtsOC_AdapterVersionUpdate:
         result = "AdapterVersionUpdate";
         break;
      case Ipc2BtsOC_AdapterTraceLevelUpdate:
         result = "AdapterTraceLevelUpdate";
         break;
      case Ipc2BtsOC_AdapterTraceCategoryUpdate:
         result = "AdapterTraceCategoryUpdate";
         break;
      case Ipc2BtsOC_AdapterAvailableSppServersUpdate:
         result = "AdapterAvailableSppServersUpdate";
         break;
      case Ipc2BtsOC_RegisterAgentResult:
         result = "RegisterAgentResult";
         break;
      case Ipc2BtsOC_UnregisterAgentResult:
         result = "UnregisterAgentResult";
         break;
      case Ipc2BtsOC_RequestDefaultAgentResult:
         result = "RequestDefaultAgentResult";
         break;
      case Ipc2BtsOC_DeviceConnectResult:
         result = "DeviceConnectResult";
         break;
      case Ipc2BtsOC_DeviceDisconnectResult:
         result = "DeviceDisconnectResult";
         break;
      case Ipc2BtsOC_PairResult:
         result = "PairResult";
         break;
      case Ipc2BtsOC_CancelPairingResult:
         result = "CancelPairingResult";
         break;
      case Ipc2BtsOC_DiscoverServicesResult:
         result = "DiscoverServicesResult";
         break;
      case Ipc2BtsOC_CancelDiscoveryResult:
         result = "CancelDiscoveryResult";
         break;
      case Ipc2BtsOC_ReportLinkkey:
         result = "ReportLinkkey";
         break;
      case Ipc2BtsOC_IncomingPairingComp:
         result = "IncomingPairingComp";
         break;
      case Ipc2BtsOC_SDPProcessReport:
         result = "SDPProcessReport";
         break;
      case Ipc2BtsOC_DeviceAddressUpdate:
         result = "DeviceAddressUpdate";
         break;
      case Ipc2BtsOC_DeviceClassUpdate:
         result = "DeviceClassUpdate";
         break;
      case Ipc2BtsOC_DeviceIconUpdate:
         result = "DeviceIconUpdate";
         break;
      case Ipc2BtsOC_DeviceUuidsUpdate:
         result = "DeviceUuidsUpdate";
         break;
      case Ipc2BtsOC_DevicePairedUpdate:
         result = "DevicePairedUpdate";
         break;
      case Ipc2BtsOC_DeviceConnectedUpdate:
         result = "DeviceConnectedUpdate";
         break;
      case Ipc2BtsOC_DeviceTrustedUpdate:
         result = "DeviceTrustedUpdate";
         break;
      case Ipc2BtsOC_DeviceBlockedUpdate:
         result = "DeviceBlockedUpdate";
         break;
      case Ipc2BtsOC_DeviceAliasUpdate:
         result = "DeviceAliasUpdate";
         break;
      case Ipc2BtsOC_DeviceAdapterUpdate:
         result = "DeviceAdapterUpdate";
         break;
      case Ipc2BtsOC_DeviceModaliasUpdate:
         result = "DeviceModaliasUpdate";
         break;
      case Ipc2BtsOC_DeviceRssiUpdate:
         result = "DeviceRssiUpdate";
         break;
      case Ipc2BtsOC_DeviceVendorIdUpdate:
         result = "DeviceVendorIdUpdate";
         break;
      case Ipc2BtsOC_DeviceVendorIdSourceUpdate:
         result = "DeviceVendorIdSourceUpdate";
         break;
      case Ipc2BtsOC_DeviceProductIdUpdate:
         result = "DeviceProductIdUpdate";
         break;
      case Ipc2BtsOC_DeviceMapInfoUpdate:
         result = "DeviceMapInfoUpdate";
         break;
      case Ipc2BtsOC_DeviceConnectedServiceUpdate:
         result = "DeviceConnectedServiceUpdate";
         break;
      case Ipc2BtsOC_DeviceVersionUpdate:
         result = "DeviceVersionUpdate";
         break;
      case Ipc2BtsOC_DevicePbapInfoUpdate:
         result = "DevicePbapInfoUpdate";
         break;
      case Ipc2BtsOC_DeviceModeUpdate:
         result = "DeviceModeUpdate";
         break;
      case Ipc2BtsOC_DeviceRoleUpdate:
         result = "DeviceRoleUpdate";
         break;
      case Ipc2BtsOC_DeviceEnableAvpPauseUpdate:
         result = "DeviceEnableAvpPauseUpdate";
         break;
      case Ipc2BtsOC_BtApplDeviceConnectReqResult:
         result = "BtApplDeviceConnectReqResult";
         break;
      case Ipc2BtsOC_BtApplDeviceDisconnectReqResult:
         result = "BtApplDeviceDisconnectReqResult";
         break;
      case Ipc2BtsOC_BtApplCancelConnectReqResult:
         result = "BtApplCancelConnectReqResult";
         break;
      case Ipc2BtsOC_BtApplGetHwVersionReqResult:
         result = "BtApplGetHwVersionReqResult";
         break;
      case Ipc2BtsOC_BtApplSetConfigurationReqResult:
         result = "BtApplSetConfigurationReqResult";
         break;
      case Ipc2BtsOC_BtApplReadConfigurationReqResult:
         result = "BtApplReadConfigurationReqResult";
         break;
      case Ipc2BtsOC_BtApplTestModeReqResult:
         result = "BtApplTestModeReqResult";
         break;
      case Ipc2BtsOC_BtApplTestModeLinkQualityReqResult:
         result = "BtApplTestModeLinkQualityReqResult";
         break;
      case Ipc2BtsOC_BtApplDeviceConnectCfm:
         result = "BtApplDeviceConnectCfm";
         break;
      case Ipc2BtsOC_BtApplDeviceConnectInd:
         result = "BtApplDeviceConnectInd";
         break;
      case Ipc2BtsOC_BtApplDeviceDisconnectCfm:
         result = "BtApplDeviceDisconnectCfm";
         break;
      case Ipc2BtsOC_BtApplDeviceDisconnectInd:
         result = "BtApplDeviceDisconnectInd";
         break;
      case Ipc2BtsOC_BtApplDeviceDisconnectCompInd:
         result = "BtApplDeviceDisconnectCompInd";
         break;
      case Ipc2BtsOC_BtApplDeviceConnectCompInd:
         result = "BtApplDeviceConnectCompInd";
         break;
      case Ipc2BtsOC_BtApplCancelConnectCfm:
         result = "BtApplCancelConnectCfm";
         break;
      case Ipc2BtsOC_BtApplStatusNotificationInd:
         result = "BtApplStatusNotificationInd";
         break;
      case Ipc2BtsOC_BtApplGetHwVersionCfm:
         result = "BtApplGetHwVersionCfm";
         break;
      case Ipc2BtsOC_BtApplSetConfigurationCfm:
         result = "BtApplSetConfigurationCfm";
         break;
      case Ipc2BtsOC_BtApplReadConfigurationCfm:
         result = "BtApplReadConfigurationCfm";
         break;
      case Ipc2BtsOC_BtApplTestModeCfm:
         result = "BtApplTestModeCfm";
         break;
      case Ipc2BtsOC_BtApplTestModeCompInd:
         result = "BtApplTestModeCompInd";
         break;
      case Ipc2BtsOC_BtApplTestModeLinkQualityCfm:
         result = "BtApplTestModeLinkQualityCfm";
         break;
      case Ipc2BtsOC_ConnectResult:
         result = "ConnectResult";
         break;
      case Ipc2BtsOC_DisconnectResult:
         result = "DisconnectResult";
         break;
      case Ipc2BtsOC_ServiceRemoteUuidUpdate:
         result = "ServiceRemoteUuidUpdate";
         break;
      case Ipc2BtsOC_ServiceStateUpdate:
         result = "ServiceStateUpdate";
         break;
      case Ipc2BtsOC_ServiceDeviceUpdate:
         result = "ServiceDeviceUpdate";
         break;
      case Ipc2BtsOC_ServiceVersionUpdate:
         result = "ServiceVersionUpdate";
         break;
      case Ipc2BtsOC_DebugTraceConfigResult:
         result = "DebugTraceConfigResult";
         break;
      case Ipc2BtsOC_ProtocolTraceConfigResult:
         result = "ProtocolTraceConfigResult";
         break;
      case Ipc2BtsOC_ReportDebugTrace:
         result = "ReportDebugTrace";
         break;
      case Ipc2BtsOC_ReportProtocolTrace:
         result = "ReportProtocolTrace";
         break;
      case Ipc2BtsOC_FatalError:
         result = "FatalError";
         break;
      case Ipc2BtsOC_GeneralError:
         result = "GeneralError";
         break;
      case Ipc2BtsOC_ReportGeniviDebugTrace:
         result = "ReportGeniviDebugTrace";
         break;
      case Ipc2BtsOC_GeniviFatalError:
         result = "GeniviFatalError";
         break;
      case Ipc2BtsOC_BtApplDidSetReqResult:
         result = "BtApplDidSetReqResult";
         break;
      case Ipc2BtsOC_BtApplDidSetCfm:
         result = "BtApplDidSetCfm";
         break;
      case Ipc2BtsOC_DunDeviceFilePathUpdate:
         result = "DunDeviceFilePathUpdate";
         break;
      case Ipc2BtsOC_BtApplSppSetUuidReqResult:
         result = "BtApplSppSetUuidReqResult";
         break;
      case Ipc2BtsOC_BtApplSppSetUuidCfm:
         result = "BtApplSppSetUuidCfm";
         break;
      case Ipc2BtsOC_BtApplSppVirtualDeviceInd:
         result = "BtApplSppVirtualDeviceInd";
         break;
      case Ipc2BtsOC_CreateSessionResult:
         result = "CreateSessionResult";
         break;
      case Ipc2BtsOC_RemoveSessionResult:
         result = "RemoveSessionResult";
         break;
      case Ipc2BtsOC_CancelSessionResult:
         result = "CancelSessionResult";
         break;
      case Ipc2BtsOC_SessionCreated:
         result = "SessionCreated";
         break;
      case Ipc2BtsOC_SessionRemoved:
         result = "SessionRemoved";
         break;
      case Ipc2BtsOC_AddTechnologyObjectPath:
         result = "AddTechnologyObjectPath";
         break;
      case Ipc2BtsOC_DelTechnologyObjectPath:
         result = "DelTechnologyObjectPath";
         break;
      case Ipc2BtsOC_AddNetworkObjectPathMapping:
         result = "AddNetworkObjectPathMapping";
         break;
      case Ipc2BtsOC_DelNetworkObjectPathMapping:
         result = "DelNetworkObjectPathMapping";
         break;
      case Ipc2BtsOC_GetConnManManagerPropertiesResult:
         result = "GetConnManManagerPropertiesResult";
         break;
      case Ipc2BtsOC_GetConnManTechnologiesResult:
         result = "GetConnManTechnologiesResult";
         break;
      case Ipc2BtsOC_GetConnManServicesResult:
         result = "GetConnManServicesResult";
         break;
      case Ipc2BtsOC_ConnManTechnologyAdded:
         result = "ConnManTechnologyAdded";
         break;
      case Ipc2BtsOC_ConnManTechnologyRemoved:
         result = "ConnManTechnologyRemoved";
         break;
      case Ipc2BtsOC_ConnManServicesChanged:
         result = "ConnManServicesChanged";
         break;
      case Ipc2BtsOC_ConnManServicesRemoved:
         result = "ConnManServicesRemoved";
         break;
      case Ipc2BtsOC_GetConnManServicePropertiesResult:
         result = "GetConnManServicePropertiesResult";
         break;
      case Ipc2BtsOC_ConnManServiceConnectResult:
         result = "ConnManServiceConnectResult";
         break;
      case Ipc2BtsOC_ConnManServiceDisconnectResult:
         result = "ConnManServiceDisconnectResult";
         break;
      case Ipc2BtsOC_ConnManServiceStateUpdate:
         result = "ConnManServiceStateUpdate";
         break;
      case Ipc2BtsOC_ConnManServiceInterfaceUpdate:
         result = "ConnManServiceInterfaceUpdate";
         break;
      case Ipc2BtsOC_SerialDeviceFilePath:
         result = "SerialDeviceFilePath";
         break;
      case Ipc2BtsOC_CharacterDeviceAddedRemoved:
         result = "CharacterDeviceAddedRemoved";
         break;
      case Ipc2BtsOC_CreateLeDeviceResult:
         result = "CreateLeDeviceResult";
         break;
      case Ipc2BtsOC_RemoveLeDeviceResult:
         result = "RemoveLeDeviceResult";
         break;
      case Ipc2BtsOC_LeAdapterInitialization:
         result = "LeAdapterInitialization";
         break;
      case Ipc2BtsOC_LeDeviceCreated:
         result = "LeDeviceCreated";
         break;
      case Ipc2BtsOC_LeDeviceRemoved:
         result = "LeDeviceRemoved";
         break;
      case Ipc2BtsOC_LeAdapterAddressTypeUpdate:
         result = "LeAdapterAddressTypeUpdate";
         break;
      case Ipc2BtsOC_LeAdapterAddressUpdate:
         result = "LeAdapterAddressUpdate";
         break;
      case Ipc2BtsOC_LeAdapterAliasUpdate:
         result = "LeAdapterAliasUpdate";
         break;
      case Ipc2BtsOC_LeAdapterAdvertisingTimeoutUpdate:
         result = "LeAdapterAdvertisingTimeoutUpdate";
         break;
      case Ipc2BtsOC_LeAdapterDiscoverableModeUpdate:
         result = "LeAdapterDiscoverableModeUpdate";
         break;
      case Ipc2BtsOC_LeAdapterAdvertisingDataUpdate:
         result = "LeAdapterAdvertisingDataUpdate";
         break;
      case Ipc2BtsOC_LeAdapterAdvertiseEnableUpdate:
         result = "LeAdapterAdvertiseEnableUpdate";
         break;
      case Ipc2BtsOC_AddLeDeviceObjectPathMapping:
         result = "AddLeDeviceObjectPathMapping";
         break;
      case Ipc2BtsOC_DelLeDeviceObjectPathMapping:
         result = "DelLeDeviceObjectPathMapping";
         break;
      case Ipc2BtsOC_LeDeviceDisconnectResult:
         result = "LeDeviceDisconnectResult";
         break;
      case Ipc2BtsOC_LeDisconnectionComp:
         result = "LeDisconnectionComp";
         break;
      case Ipc2BtsOC_LeDeviceAddressTypeUpdate:
         result = "LeDeviceAddressTypeUpdate";
         break;
      case Ipc2BtsOC_LeDeviceAddressUpdate:
         result = "LeDeviceAddressUpdate";
         break;
      case Ipc2BtsOC_LeDeviceConnectedUpdate:
         result = "LeDeviceConnectedUpdate";
         break;
      case Ipc2BtsOC_SendSeamlessPairingErrorCodeResult:
         result = "SendSeamlessPairingErrorCodeResult";
         break;
      case Ipc2BtsOC_SeamlessPairingAllowAccessResult:
         result = "SeamlessPairingAllowAccessResult";
         break;
      case Ipc2BtsOC_SeamlessPairingErrorCodeReceived:
         result = "SeamlessPairingErrorCodeReceived";
         break;
      case Ipc2BtsOC_SeamlessPairingAccessRequest:
         result = "SeamlessPairingAccessRequest";
         break;
      case Ipc2BtsOC_SeamlessPairingPairingDataUpdate:
         result = "SeamlessPairingPairingDataUpdate";
         break;
      case Ipc2BtsOC_ConnectionBlockEnd:
         result = "ConnectionBlockEnd";
         break;
      case Ipc2BtsOC_TelephonyBlockStart:
         result = "TelephonyBlockStart";
         break;
      case Ipc2BtsOC_ServiceAvailabilityTelephony:
         result = "ServiceAvailabilityTelephony";
         break;
      case Ipc2BtsOC_AddHfpInterfaceObjectPathMapping:
         result = "AddHfpInterfaceObjectPathMapping";
         break;
      case Ipc2BtsOC_DelHfpInterfaceObjectPathMapping:
         result = "DelHfpInterfaceObjectPathMapping";
         break;
      case Ipc2BtsOC_GetHandsfreeProperties:
         result = "GetHandsfreeProperties";
         break;
      case Ipc2BtsOC_GetHandsfreePropertiesExt:
         result = "GetHandsfreePropertiesExt";
         break;
      case Ipc2BtsOC_HandsfreeFeaturesUpdate:
         result = "HandsfreeFeaturesUpdate";
         break;
      case Ipc2BtsOC_HandsfreeInbandRingingUpdate:
         result = "HandsfreeInbandRingingUpdate";
         break;
      case Ipc2BtsOC_GetModems:
         result = "GetModems";
         break;
      case Ipc2BtsOC_GetModemsExt:
         result = "GetModemsExt";
         break;
      case Ipc2BtsOC_ModemAdded:
         result = "ModemAdded";
         break;
      case Ipc2BtsOC_ModemAddedExt:
         result = "ModemAddedExt";
         break;
      case Ipc2BtsOC_ModemRemoved:
         result = "ModemRemoved";
         break;
      case Ipc2BtsOC_GetModemProperties:
         result = "GetModemProperties";
         break;
      case Ipc2BtsOC_GetModemPropertiesExt:
         result = "GetModemPropertiesExt";
         break;
      case Ipc2BtsOC_ModemInterfacesUpdate:
         result = "ModemInterfacesUpdate";
         break;
      case Ipc2BtsOC_TelephonyBlockEnd:
         result = "TelephonyBlockEnd";
         break;
      case Ipc2BtsOC_PhonebookBlockStart:
         result = "PhonebookBlockStart";
         break;
      case Ipc2BtsOC_ServiceAvailabilityPhonebook:
         result = "ServiceAvailabilityPhonebook";
         break;
      case Ipc2BtsOC_PimSessionSourceUpdate:
         result = "PimSessionSourceUpdate";
         break;
      case Ipc2BtsOC_PimSessionDestinationUpdate:
         result = "PimSessionDestinationUpdate";
         break;
      case Ipc2BtsOC_PimSessionChannelUpdate:
         result = "PimSessionChannelUpdate";
         break;
      case Ipc2BtsOC_PimSessionTargetUpdate:
         result = "PimSessionTargetUpdate";
         break;
      case Ipc2BtsOC_PimTransferCancelResult:
         result = "PimTransferCancelResult";
         break;
      case Ipc2BtsOC_PimTransferStatusUpdate:
         result = "PimTransferStatusUpdate";
         break;
      case Ipc2BtsOC_PimTransferSessionUpdate:
         result = "PimTransferSessionUpdate";
         break;
      case Ipc2BtsOC_PimTransferNameUpdate:
         result = "PimTransferNameUpdate";
         break;
      case Ipc2BtsOC_PimTransferTypeUpdate:
         result = "PimTransferTypeUpdate";
         break;
      case Ipc2BtsOC_PimTransferTimeUpdate:
         result = "PimTransferTimeUpdate";
         break;
      case Ipc2BtsOC_PimTransferSizeUpdate:
         result = "PimTransferSizeUpdate";
         break;
      case Ipc2BtsOC_PimTransferTransferredUpdate:
         result = "PimTransferTransferredUpdate";
         break;
      case Ipc2BtsOC_PimTransferFilenameUpdate:
         result = "PimTransferFilenameUpdate";
         break;
      case Ipc2BtsOC_PhonebookBlockEnd:
         result = "PhonebookBlockEnd";
         break;
      case Ipc2BtsOC_MessagingBlockStart:
         result = "MessagingBlockStart";
         break;
      case Ipc2BtsOC_ServiceAvailabilityMessaging:
         result = "ServiceAvailabilityMessaging";
         break;
      case Ipc2BtsOC_MsgSessionSourceUpdate:
         result = "MsgSessionSourceUpdate";
         break;
      case Ipc2BtsOC_MsgSessionDestinationUpdate:
         result = "MsgSessionDestinationUpdate";
         break;
      case Ipc2BtsOC_MsgSessionChannelUpdate:
         result = "MsgSessionChannelUpdate";
         break;
      case Ipc2BtsOC_MsgSessionTargetUpdate:
         result = "MsgSessionTargetUpdate";
         break;
      case Ipc2BtsOC_MsgTransferCancelResult:
         result = "MsgTransferCancelResult";
         break;
      case Ipc2BtsOC_MsgTransferStatusUpdate:
         result = "MsgTransferStatusUpdate";
         break;
      case Ipc2BtsOC_MsgTransferSessionUpdate:
         result = "MsgTransferSessionUpdate";
         break;
      case Ipc2BtsOC_MsgTransferNameUpdate:
         result = "MsgTransferNameUpdate";
         break;
      case Ipc2BtsOC_MsgTransferTypeUpdate:
         result = "MsgTransferTypeUpdate";
         break;
      case Ipc2BtsOC_MsgTransferTimeUpdate:
         result = "MsgTransferTimeUpdate";
         break;
      case Ipc2BtsOC_MsgTransferSizeUpdate:
         result = "MsgTransferSizeUpdate";
         break;
      case Ipc2BtsOC_MsgTransferTransferredUpdate:
         result = "MsgTransferTransferredUpdate";
         break;
      case Ipc2BtsOC_MsgTransferFilenameUpdate:
         result = "MsgTransferFilenameUpdate";
         break;
      case Ipc2BtsOC_MessagingBlockEnd:
         result = "MessagingBlockEnd";
         break;
      case Ipc2BtsOC_MediaPlayerBlockStart:
         result = "MediaPlayerBlockStart";
         break;
      case Ipc2BtsOC_ServiceAvailabilityMediaPlayer:
         result = "ServiceAvailabilityMediaPlayer";
         break;
      case Ipc2BtsOC_MediaPlayerBlockEnd:
         result = "MediaPlayerBlockEnd";
         break;
      case Ipc2BtsOC_Last:
         result = "Last";
         break;
      default:
         break;
   }

   return result;
}

} //genivi
} //btstackif
