/**
 * @file ConnManTypes.cpp
 *
 * @par SW-Component
 * Types
 *
 * @brief Basic types for ConnMan.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all internal types for ConnMan.
 */

#include "ConnManTypes.h"

namespace btstackif {
namespace genivi {

ConnManManagerProperty::ConnManManagerProperty()
{
   state = ::ccdbusif::connman::MANAGER_STATE_UNKNOWN;
   offlineMode = false;
   sessionMode = false;
}

ConnManManagerProperty::ConnManManagerProperty(IN const ConnManManagerProperty& ref)
{
   state = ref.state;
   offlineMode = ref.offlineMode;
   sessionMode = ref.sessionMode;
}

ConnManManagerProperty& ConnManManagerProperty::operator=(IN const ConnManManagerProperty& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   state = ref.state;
   offlineMode = ref.offlineMode;
   sessionMode = ref.sessionMode;

   return *this;
}

bool ConnManManagerProperty::operator==(IN const ConnManManagerProperty& ref) const
{
   bool result = true;

   result = (true == result) && (state == ref.state);
   result = (true == result) && (offlineMode == ref.offlineMode);
   result = (true == result) && (sessionMode == ref.sessionMode);

   return result;
}

bool ConnManManagerProperty::operator!=(IN const ConnManManagerProperty& ref) const
{
   return !(operator==(ref));
}

ConnManManagerProperty::~ConnManManagerProperty()
{
}

//------------------------------------------------------------------------------

ConnManTechnologyProperty::ConnManTechnologyProperty()
{
   powered = false;
   connected = false;
   // name
   type = ::ccdbusif::connman::SERVICE_TYPE_UNKNOWN;
   tethering = false;
}

ConnManTechnologyProperty::ConnManTechnologyProperty(IN const ConnManTechnologyProperty& ref)
{
   powered = ref.powered;
   connected = ref.connected;
   name = ref.name;
   type = ref.type;
   tethering = ref.tethering;
}

ConnManTechnologyProperty& ConnManTechnologyProperty::operator=(IN const ConnManTechnologyProperty& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   powered = ref.powered;
   connected = ref.connected;
   name = ref.name;
   type = ref.type;
   tethering = ref.tethering;

   return *this;
}

bool ConnManTechnologyProperty::operator==(IN const ConnManTechnologyProperty& ref) const
{
   bool result = true;

   result = (true == result) && (powered == ref.powered);
   result = (true == result) && (connected == ref.connected);
   result = (true == result) && (name == ref.name);
   result = (true == result) && (type == ref.type);
   result = (true == result) && (tethering == ref.tethering);

   return result;
}

bool ConnManTechnologyProperty::operator!=(IN const ConnManTechnologyProperty& ref) const
{
   return !(operator==(ref));
}

ConnManTechnologyProperty::~ConnManTechnologyProperty()
{
}

//------------------------------------------------------------------------------

ConnManTechnologyItem::ConnManTechnologyItem()
{
   // objPath
   // technology
}

ConnManTechnologyItem::ConnManTechnologyItem(IN const ConnManTechnologyItem& ref)
{
   objPath = ref.objPath;
   technology = ref.technology;
}

ConnManTechnologyItem& ConnManTechnologyItem::operator=(IN const ConnManTechnologyItem& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   objPath = ref.objPath;
   technology = ref.technology;

   return *this;
}

bool ConnManTechnologyItem::operator==(IN const ConnManTechnologyItem& ref) const
{
   bool result = true;

   result = (true == result) && (objPath == ref.objPath);
   result = (true == result) && (technology == ref.technology);

   return result;
}

bool ConnManTechnologyItem::operator!=(IN const ConnManTechnologyItem& ref) const
{
   return !(operator==(ref));
}

ConnManTechnologyItem::~ConnManTechnologyItem()
{
}

//------------------------------------------------------------------------------

ConnManServiceProperty::ConnManServiceProperty()
{
   // name
   type = ::ccdbusif::connman::SERVICE_TYPE_UNKNOWN;
   state = ::ccdbusif::connman::SERVICE_STATE_UNKNOWN;
   autoConnect = false;
   // interface
}

ConnManServiceProperty::ConnManServiceProperty(IN const ConnManServiceProperty& ref)
{
   name = ref.name;
   type = ref.type;
   state = ref.state;
   autoConnect = ref.autoConnect;
   interface = ref.interface;
}

ConnManServiceProperty& ConnManServiceProperty::operator=(IN const ConnManServiceProperty& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   name = ref.name;
   type = ref.type;
   state = ref.state;
   autoConnect = ref.autoConnect;
   interface = ref.interface;

   return *this;
}

bool ConnManServiceProperty::operator==(IN const ConnManServiceProperty& ref) const
{
   bool result = true;

   result = (true == result) && (name == ref.name);
   result = (true == result) && (type == ref.type);
   result = (true == result) && (state == ref.state);
   result = (true == result) && (autoConnect == ref.autoConnect);
   result = (true == result) && (interface == ref.interface);

   return result;
}

bool ConnManServiceProperty::operator!=(IN const ConnManServiceProperty& ref) const
{
   return !(operator==(ref));
}

ConnManServiceProperty::~ConnManServiceProperty()
{
}

//------------------------------------------------------------------------------

ConnManServiceItem::ConnManServiceItem()
{
   // objPath
   // service
}

ConnManServiceItem::ConnManServiceItem(IN const ConnManServiceItem& ref)
{
   objPath = ref.objPath;
   service = ref.service;
}

ConnManServiceItem& ConnManServiceItem::operator=(IN const ConnManServiceItem& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   objPath = ref.objPath;
   service = ref.service;

   return *this;
}

bool ConnManServiceItem::operator==(IN const ConnManServiceItem& ref) const
{
   bool result = true;

   result = (true == result) && (objPath == ref.objPath);
   result = (true == result) && (service == ref.service);

   return result;
}

bool ConnManServiceItem::operator!=(IN const ConnManServiceItem& ref) const
{
   return !(operator==(ref));
}

ConnManServiceItem::~ConnManServiceItem()
{
}

} //genivi
} //btstackif
