/**
 * @file ConnManTypes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief Basic types for ConnMan.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all internal types for ConnMan.
 */

#ifndef _CONN_MAN_STACK_TYPES_H_
#define _CONN_MAN_STACK_TYPES_H_

#include "BtStackInternalTypes.h"

#include "cc_dbus_if/ConnManDbusTypes.h"

namespace btstackif {
namespace genivi {

/*
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions), implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */
class ConnManTechnologyItem;
class ConnManServiceItem;

/**
 * Type definition for list of Technologies.
 */
typedef ::std::vector<ConnManTechnologyItem> ConnManTechnologyList;

/**
 * Type definition for list of services.
 */
typedef ::std::vector<ConnManServiceItem> ConnManServiceList;

/**
 * Type definition for ConnMan manager properties.
 */
class ConnManManagerProperty
{
public:
   ConnManManagerProperty();
   ConnManManagerProperty(IN const ConnManManagerProperty& ref);
   ConnManManagerProperty& operator=(IN const ConnManManagerProperty& ref);
   bool operator==(IN const ConnManManagerProperty& ref) const;
   bool operator!=(IN const ConnManManagerProperty& ref) const;
   virtual ~ConnManManagerProperty();
   // member with public access
   ::ccdbusif::connman::ManagerState state;
   bool offlineMode;
   bool sessionMode;
};

/**
 * Type definition for ConnMan Technology properties.
 */
class ConnManTechnologyProperty
{
public:
   ConnManTechnologyProperty();
   ConnManTechnologyProperty(IN const ConnManTechnologyProperty& ref);
   ConnManTechnologyProperty& operator=(IN const ConnManTechnologyProperty& ref);
   bool operator==(IN const ConnManTechnologyProperty& ref) const;
   bool operator!=(IN const ConnManTechnologyProperty& ref) const;
   virtual ~ConnManTechnologyProperty();
   // member with public access
   bool powered;
   bool connected;
   ::std::string name;
   ::ccdbusif::connman::ServiceType type;
   bool tethering;
};

/**
 * Type definition for ConnMan Technology Item.
 */
class ConnManTechnologyItem
{
public:
   ConnManTechnologyItem();
   ConnManTechnologyItem(IN const ConnManTechnologyItem& ref);
   ConnManTechnologyItem& operator=(IN const ConnManTechnologyItem& ref);
   bool operator==(IN const ConnManTechnologyItem& ref) const;
   bool operator!=(IN const ConnManTechnologyItem& ref) const;
   virtual ~ConnManTechnologyItem();
   // member with public access
   BTSObjectPath objPath;
   ConnManTechnologyProperty technology;
};

/**
 * Type definition for ConnMan service properties.
 */
class ConnManServiceProperty
{
public:
   ConnManServiceProperty();
   ConnManServiceProperty(IN const ConnManServiceProperty& ref);
   ConnManServiceProperty& operator=(IN const ConnManServiceProperty& ref);
   bool operator==(IN const ConnManServiceProperty& ref) const;
   bool operator!=(IN const ConnManServiceProperty& ref) const;
   virtual ~ConnManServiceProperty();
   // member with public access
   ::std::string name;
   ::ccdbusif::connman::ServiceType type;
   ::ccdbusif::connman::ServiceState state;
   bool autoConnect;
   BTSDeviceName interface;
};

/**
 * Type definition for ConnMan service item.
 */
class ConnManServiceItem
{
public:
   ConnManServiceItem();
   ConnManServiceItem(IN const ConnManServiceItem& ref);
   ConnManServiceItem& operator=(IN const ConnManServiceItem& ref);
   bool operator==(IN const ConnManServiceItem& ref) const;
   bool operator!=(IN const ConnManServiceItem& ref) const;
   virtual ~ConnManServiceItem();
   // member with public access
   BTSObjectPath objPath;
   ConnManServiceProperty service;
};

} //genivi
} //btstackif

#endif //_CONN_MAN_STACK_TYPES_H_
