/**
 * @file Bts2Ipc_Telephony_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_TELEPHONY.
 */

#include "Bts2Ipc_Telephony_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Bts2Ipc_GetManagedObjectsTelephony::Bts2Ipc_GetManagedObjectsTelephony()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Bts2IpcOC_GetManagedObjectsTelephony))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_TELEPHONY);
}

Bts2Ipc_GetManagedObjectsTelephony::Bts2Ipc_GetManagedObjectsTelephony(IN const Bts2Ipc_GetManagedObjectsTelephony& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetManagedObjectsTelephony& Bts2Ipc_GetManagedObjectsTelephony::operator=(IN const Bts2Ipc_GetManagedObjectsTelephony& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetManagedObjectsTelephony::~Bts2Ipc_GetManagedObjectsTelephony()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetManagedObjectsTelephony::clone(void) const
{
   return new Bts2Ipc_GetManagedObjectsTelephony(*this);
}

Bts2Ipc_GetAllPropertiesTelephony::Bts2Ipc_GetAllPropertiesTelephony()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Bts2IpcOC_GetAllPropertiesTelephony))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   // _interface: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_TELEPHONY);
}

Bts2Ipc_GetAllPropertiesTelephony::Bts2Ipc_GetAllPropertiesTelephony(IN const Bts2Ipc_GetAllPropertiesTelephony& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;
}

Bts2Ipc_GetAllPropertiesTelephony& Bts2Ipc_GetAllPropertiesTelephony::operator=(IN const Bts2Ipc_GetAllPropertiesTelephony& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;

   return *this;
}

Bts2Ipc_GetAllPropertiesTelephony::~Bts2Ipc_GetAllPropertiesTelephony()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAllPropertiesTelephony::clone(void) const
{
   return new Bts2Ipc_GetAllPropertiesTelephony(*this);
}

Bts2Ipc_GetIntrospectionTelephony::Bts2Ipc_GetIntrospectionTelephony()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Bts2IpcOC_GetIntrospectionTelephony))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_TELEPHONY);
}

Bts2Ipc_GetIntrospectionTelephony::Bts2Ipc_GetIntrospectionTelephony(IN const Bts2Ipc_GetIntrospectionTelephony& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetIntrospectionTelephony& Bts2Ipc_GetIntrospectionTelephony::operator=(IN const Bts2Ipc_GetIntrospectionTelephony& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetIntrospectionTelephony::~Bts2Ipc_GetIntrospectionTelephony()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetIntrospectionTelephony::clone(void) const
{
   return new Bts2Ipc_GetIntrospectionTelephony(*this);
}

Bts2Ipc_GetHandsfreeProperties::Bts2Ipc_GetHandsfreeProperties()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Bts2IpcOC_GetHandsfreeProperties))
{
   // _modem: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_TELEPHONY);
}

Bts2Ipc_GetHandsfreeProperties::Bts2Ipc_GetHandsfreeProperties(IN const Bts2Ipc_GetHandsfreeProperties& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _modem = ref._modem;
}

Bts2Ipc_GetHandsfreeProperties& Bts2Ipc_GetHandsfreeProperties::operator=(IN const Bts2Ipc_GetHandsfreeProperties& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _modem = ref._modem;

   return *this;
}

Bts2Ipc_GetHandsfreeProperties::~Bts2Ipc_GetHandsfreeProperties()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetHandsfreeProperties::clone(void) const
{
   return new Bts2Ipc_GetHandsfreeProperties(*this);
}

Bts2Ipc_GetModems::Bts2Ipc_GetModems()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Bts2IpcOC_GetModems))
{
   setBtsSourceFunctionBlock(BTS_FB_TELEPHONY);
}

Bts2Ipc_GetModems::Bts2Ipc_GetModems(IN const Bts2Ipc_GetModems& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetModems& Bts2Ipc_GetModems::operator=(IN const Bts2Ipc_GetModems& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetModems::~Bts2Ipc_GetModems()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetModems::clone(void) const
{
   return new Bts2Ipc_GetModems(*this);
}

Bts2Ipc_GetModemProperties::Bts2Ipc_GetModemProperties()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_TELEPHONY), (BTSCommonEnumClass)(Bts2IpcOC_GetModemProperties))
{
   // _modem: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_TELEPHONY);
}

Bts2Ipc_GetModemProperties::Bts2Ipc_GetModemProperties(IN const Bts2Ipc_GetModemProperties& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _modem = ref._modem;
}

Bts2Ipc_GetModemProperties& Bts2Ipc_GetModemProperties::operator=(IN const Bts2Ipc_GetModemProperties& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _modem = ref._modem;

   return *this;
}

Bts2Ipc_GetModemProperties::~Bts2Ipc_GetModemProperties()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetModemProperties::clone(void) const
{
   return new Bts2Ipc_GetModemProperties(*this);
}

} //genivi
} //btstackif
