/**
 * @file Bts2Ipc_Phonebook_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_PHONEBOOK.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_PHONEBOOK.
 */

#include "Bts2Ipc_Phonebook_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Bts2Ipc_GetManagedObjectsPhonebook::Bts2Ipc_GetManagedObjectsPhonebook()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetManagedObjectsPhonebook))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetManagedObjectsPhonebook::Bts2Ipc_GetManagedObjectsPhonebook(IN const Bts2Ipc_GetManagedObjectsPhonebook& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetManagedObjectsPhonebook& Bts2Ipc_GetManagedObjectsPhonebook::operator=(IN const Bts2Ipc_GetManagedObjectsPhonebook& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetManagedObjectsPhonebook::~Bts2Ipc_GetManagedObjectsPhonebook()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetManagedObjectsPhonebook::clone(void) const
{
   return new Bts2Ipc_GetManagedObjectsPhonebook(*this);
}

Bts2Ipc_GetAllPropertiesPhonebook::Bts2Ipc_GetAllPropertiesPhonebook()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetAllPropertiesPhonebook))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   // _interface: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetAllPropertiesPhonebook::Bts2Ipc_GetAllPropertiesPhonebook(IN const Bts2Ipc_GetAllPropertiesPhonebook& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;
}

Bts2Ipc_GetAllPropertiesPhonebook& Bts2Ipc_GetAllPropertiesPhonebook::operator=(IN const Bts2Ipc_GetAllPropertiesPhonebook& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;

   return *this;
}

Bts2Ipc_GetAllPropertiesPhonebook::~Bts2Ipc_GetAllPropertiesPhonebook()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAllPropertiesPhonebook::clone(void) const
{
   return new Bts2Ipc_GetAllPropertiesPhonebook(*this);
}

Bts2Ipc_GetIntrospectionPhonebook::Bts2Ipc_GetIntrospectionPhonebook()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetIntrospectionPhonebook))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetIntrospectionPhonebook::Bts2Ipc_GetIntrospectionPhonebook(IN const Bts2Ipc_GetIntrospectionPhonebook& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetIntrospectionPhonebook& Bts2Ipc_GetIntrospectionPhonebook::operator=(IN const Bts2Ipc_GetIntrospectionPhonebook& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetIntrospectionPhonebook::~Bts2Ipc_GetIntrospectionPhonebook()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetIntrospectionPhonebook::clone(void) const
{
   return new Bts2Ipc_GetIntrospectionPhonebook(*this);
}

Bts2Ipc_GetPimSessionSource::Bts2Ipc_GetPimSessionSource()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimSessionSource))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimSessionSource::Bts2Ipc_GetPimSessionSource(IN const Bts2Ipc_GetPimSessionSource& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimSessionSource& Bts2Ipc_GetPimSessionSource::operator=(IN const Bts2Ipc_GetPimSessionSource& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimSessionSource::~Bts2Ipc_GetPimSessionSource()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimSessionSource::clone(void) const
{
   return new Bts2Ipc_GetPimSessionSource(*this);
}

Bts2Ipc_GetPimSessionDestination::Bts2Ipc_GetPimSessionDestination()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimSessionDestination))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimSessionDestination::Bts2Ipc_GetPimSessionDestination(IN const Bts2Ipc_GetPimSessionDestination& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimSessionDestination& Bts2Ipc_GetPimSessionDestination::operator=(IN const Bts2Ipc_GetPimSessionDestination& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimSessionDestination::~Bts2Ipc_GetPimSessionDestination()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimSessionDestination::clone(void) const
{
   return new Bts2Ipc_GetPimSessionDestination(*this);
}

Bts2Ipc_GetPimSessionChannel::Bts2Ipc_GetPimSessionChannel()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimSessionChannel))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimSessionChannel::Bts2Ipc_GetPimSessionChannel(IN const Bts2Ipc_GetPimSessionChannel& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimSessionChannel& Bts2Ipc_GetPimSessionChannel::operator=(IN const Bts2Ipc_GetPimSessionChannel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimSessionChannel::~Bts2Ipc_GetPimSessionChannel()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimSessionChannel::clone(void) const
{
   return new Bts2Ipc_GetPimSessionChannel(*this);
}

Bts2Ipc_GetPimSessionTarget::Bts2Ipc_GetPimSessionTarget()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimSessionTarget))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimSessionTarget::Bts2Ipc_GetPimSessionTarget(IN const Bts2Ipc_GetPimSessionTarget& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimSessionTarget& Bts2Ipc_GetPimSessionTarget::operator=(IN const Bts2Ipc_GetPimSessionTarget& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimSessionTarget::~Bts2Ipc_GetPimSessionTarget()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimSessionTarget::clone(void) const
{
   return new Bts2Ipc_GetPimSessionTarget(*this);
}

Bts2Ipc_PimTransferCancel::Bts2Ipc_PimTransferCancel()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_PimTransferCancel))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_PimTransferCancel::Bts2Ipc_PimTransferCancel(IN const Bts2Ipc_PimTransferCancel& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_PimTransferCancel& Bts2Ipc_PimTransferCancel::operator=(IN const Bts2Ipc_PimTransferCancel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_PimTransferCancel::~Bts2Ipc_PimTransferCancel()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_PimTransferCancel::clone(void) const
{
   return new Bts2Ipc_PimTransferCancel(*this);
}

Bts2Ipc_GetPimTransferStatus::Bts2Ipc_GetPimTransferStatus()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferStatus))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferStatus::Bts2Ipc_GetPimTransferStatus(IN const Bts2Ipc_GetPimTransferStatus& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferStatus& Bts2Ipc_GetPimTransferStatus::operator=(IN const Bts2Ipc_GetPimTransferStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferStatus::~Bts2Ipc_GetPimTransferStatus()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferStatus::clone(void) const
{
   return new Bts2Ipc_GetPimTransferStatus(*this);
}

Bts2Ipc_GetPimTransferSession::Bts2Ipc_GetPimTransferSession()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferSession))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferSession::Bts2Ipc_GetPimTransferSession(IN const Bts2Ipc_GetPimTransferSession& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferSession& Bts2Ipc_GetPimTransferSession::operator=(IN const Bts2Ipc_GetPimTransferSession& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferSession::~Bts2Ipc_GetPimTransferSession()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferSession::clone(void) const
{
   return new Bts2Ipc_GetPimTransferSession(*this);
}

Bts2Ipc_GetPimTransferName::Bts2Ipc_GetPimTransferName()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferName))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferName::Bts2Ipc_GetPimTransferName(IN const Bts2Ipc_GetPimTransferName& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferName& Bts2Ipc_GetPimTransferName::operator=(IN const Bts2Ipc_GetPimTransferName& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferName::~Bts2Ipc_GetPimTransferName()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferName::clone(void) const
{
   return new Bts2Ipc_GetPimTransferName(*this);
}

Bts2Ipc_GetPimTransferType::Bts2Ipc_GetPimTransferType()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferType))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferType::Bts2Ipc_GetPimTransferType(IN const Bts2Ipc_GetPimTransferType& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferType& Bts2Ipc_GetPimTransferType::operator=(IN const Bts2Ipc_GetPimTransferType& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferType::~Bts2Ipc_GetPimTransferType()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferType::clone(void) const
{
   return new Bts2Ipc_GetPimTransferType(*this);
}

Bts2Ipc_GetPimTransferTime::Bts2Ipc_GetPimTransferTime()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferTime))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferTime::Bts2Ipc_GetPimTransferTime(IN const Bts2Ipc_GetPimTransferTime& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferTime& Bts2Ipc_GetPimTransferTime::operator=(IN const Bts2Ipc_GetPimTransferTime& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferTime::~Bts2Ipc_GetPimTransferTime()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferTime::clone(void) const
{
   return new Bts2Ipc_GetPimTransferTime(*this);
}

Bts2Ipc_GetPimTransferSize::Bts2Ipc_GetPimTransferSize()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferSize))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferSize::Bts2Ipc_GetPimTransferSize(IN const Bts2Ipc_GetPimTransferSize& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferSize& Bts2Ipc_GetPimTransferSize::operator=(IN const Bts2Ipc_GetPimTransferSize& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferSize::~Bts2Ipc_GetPimTransferSize()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferSize::clone(void) const
{
   return new Bts2Ipc_GetPimTransferSize(*this);
}

Bts2Ipc_GetPimTransferTransferred::Bts2Ipc_GetPimTransferTransferred()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferTransferred))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferTransferred::Bts2Ipc_GetPimTransferTransferred(IN const Bts2Ipc_GetPimTransferTransferred& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferTransferred& Bts2Ipc_GetPimTransferTransferred::operator=(IN const Bts2Ipc_GetPimTransferTransferred& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferTransferred::~Bts2Ipc_GetPimTransferTransferred()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferTransferred::clone(void) const
{
   return new Bts2Ipc_GetPimTransferTransferred(*this);
}

Bts2Ipc_GetPimTransferFilename::Bts2Ipc_GetPimTransferFilename()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_PHONEBOOK), (BTSCommonEnumClass)(Bts2IpcOC_GetPimTransferFilename))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_PHONEBOOK);
}

Bts2Ipc_GetPimTransferFilename::Bts2Ipc_GetPimTransferFilename(IN const Bts2Ipc_GetPimTransferFilename& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetPimTransferFilename& Bts2Ipc_GetPimTransferFilename::operator=(IN const Bts2Ipc_GetPimTransferFilename& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetPimTransferFilename::~Bts2Ipc_GetPimTransferFilename()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetPimTransferFilename::clone(void) const
{
   return new Bts2Ipc_GetPimTransferFilename(*this);
}

} //genivi
} //btstackif
