/**
 * @file Bts2Ipc_Telephony_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_TELEPHONY.
 */

#ifndef _BTS_2_IPC_TELEPHONY_MSG_GENIVI_H_
#define _BTS_2_IPC_TELEPHONY_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Bts2Ipc_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Bts2Ipc_GetManagedObjectsTelephony : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetManagedObjectsTelephony();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetManagedObjectsTelephony(IN const Bts2Ipc_GetManagedObjectsTelephony& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetManagedObjectsTelephony& operator=(IN const Bts2Ipc_GetManagedObjectsTelephony& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetManagedObjectsTelephony();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetAllPropertiesTelephony : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAllPropertiesTelephony();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAllPropertiesTelephony(IN const Bts2Ipc_GetAllPropertiesTelephony& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAllPropertiesTelephony& operator=(IN const Bts2Ipc_GetAllPropertiesTelephony& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAllPropertiesTelephony();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }
   inline void setInterface(IN const BTSDbusInterface& interface) { _interface = interface; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }
   inline void getInterface(OUT BTSDbusInterface& interface) const { interface = _interface; }
   inline const BTSDbusInterface& getInterface(void) const { return _interface; }
   inline BTSDbusInterface& getInterfaceMutable(void) { return _interface; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
   BTSDbusInterface _interface; /**< parameter interface */
};

/**
 *
 */
class Bts2Ipc_GetIntrospectionTelephony : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetIntrospectionTelephony();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetIntrospectionTelephony(IN const Bts2Ipc_GetIntrospectionTelephony& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetIntrospectionTelephony& operator=(IN const Bts2Ipc_GetIntrospectionTelephony& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetIntrospectionTelephony();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetHandsfreeProperties : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetHandsfreeProperties();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetHandsfreeProperties(IN const Bts2Ipc_GetHandsfreeProperties& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetHandsfreeProperties& operator=(IN const Bts2Ipc_GetHandsfreeProperties& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetHandsfreeProperties();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Bts2Ipc_GetModems : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetModems();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetModems(IN const Bts2Ipc_GetModems& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetModems& operator=(IN const Bts2Ipc_GetModems& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetModems();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetModemProperties : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetModemProperties();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetModemProperties(IN const Bts2Ipc_GetModemProperties& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetModemProperties& operator=(IN const Bts2Ipc_GetModemProperties& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetModemProperties();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _modem; /**< parameter modem */
};

} //genivi
} //btstackif

#endif //_BTS_2_IPC_TELEPHONY_MSG_GENIVI_H_
