/**
 * @file Bts2Ipc_Messaging_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_MESSAGING.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_MESSAGING.
 */

#ifndef _BTS_2_IPC_MESSAGING_MSG_GENIVI_H_
#define _BTS_2_IPC_MESSAGING_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Bts2Ipc_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Bts2Ipc_GetManagedObjectsMessaging : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetManagedObjectsMessaging();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetManagedObjectsMessaging(IN const Bts2Ipc_GetManagedObjectsMessaging& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetManagedObjectsMessaging& operator=(IN const Bts2Ipc_GetManagedObjectsMessaging& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetManagedObjectsMessaging();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetAllPropertiesMessaging : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAllPropertiesMessaging();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAllPropertiesMessaging(IN const Bts2Ipc_GetAllPropertiesMessaging& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAllPropertiesMessaging& operator=(IN const Bts2Ipc_GetAllPropertiesMessaging& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAllPropertiesMessaging();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }
   inline void setInterface(IN const BTSDbusInterface& interface) { _interface = interface; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }
   inline void getInterface(OUT BTSDbusInterface& interface) const { interface = _interface; }
   inline const BTSDbusInterface& getInterface(void) const { return _interface; }
   inline BTSDbusInterface& getInterfaceMutable(void) { return _interface; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
   BTSDbusInterface _interface; /**< parameter interface */
};

/**
 *
 */
class Bts2Ipc_GetIntrospectionMessaging : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetIntrospectionMessaging();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetIntrospectionMessaging(IN const Bts2Ipc_GetIntrospectionMessaging& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetIntrospectionMessaging& operator=(IN const Bts2Ipc_GetIntrospectionMessaging& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetIntrospectionMessaging();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgSessionSource : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgSessionSource();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgSessionSource(IN const Bts2Ipc_GetMsgSessionSource& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgSessionSource& operator=(IN const Bts2Ipc_GetMsgSessionSource& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgSessionSource();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgSessionDestination : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgSessionDestination();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgSessionDestination(IN const Bts2Ipc_GetMsgSessionDestination& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgSessionDestination& operator=(IN const Bts2Ipc_GetMsgSessionDestination& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgSessionDestination();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgSessionChannel : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgSessionChannel();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgSessionChannel(IN const Bts2Ipc_GetMsgSessionChannel& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgSessionChannel& operator=(IN const Bts2Ipc_GetMsgSessionChannel& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgSessionChannel();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgSessionTarget : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgSessionTarget();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgSessionTarget(IN const Bts2Ipc_GetMsgSessionTarget& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgSessionTarget& operator=(IN const Bts2Ipc_GetMsgSessionTarget& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgSessionTarget();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_MsgTransferCancel : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_MsgTransferCancel();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_MsgTransferCancel(IN const Bts2Ipc_MsgTransferCancel& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_MsgTransferCancel& operator=(IN const Bts2Ipc_MsgTransferCancel& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_MsgTransferCancel();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferStatus : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferStatus(IN const Bts2Ipc_GetMsgTransferStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferStatus& operator=(IN const Bts2Ipc_GetMsgTransferStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferSession : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferSession();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferSession(IN const Bts2Ipc_GetMsgTransferSession& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferSession& operator=(IN const Bts2Ipc_GetMsgTransferSession& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferSession();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferName : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferName();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferName(IN const Bts2Ipc_GetMsgTransferName& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferName& operator=(IN const Bts2Ipc_GetMsgTransferName& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferName();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferType : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferType();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferType(IN const Bts2Ipc_GetMsgTransferType& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferType& operator=(IN const Bts2Ipc_GetMsgTransferType& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferType();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferTime : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferTime();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferTime(IN const Bts2Ipc_GetMsgTransferTime& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferTime& operator=(IN const Bts2Ipc_GetMsgTransferTime& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferTime();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferSize : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferSize();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferSize(IN const Bts2Ipc_GetMsgTransferSize& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferSize& operator=(IN const Bts2Ipc_GetMsgTransferSize& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferSize();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferTransferred : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferTransferred();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferTransferred(IN const Bts2Ipc_GetMsgTransferTransferred& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferTransferred& operator=(IN const Bts2Ipc_GetMsgTransferTransferred& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferTransferred();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetMsgTransferFilename : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetMsgTransferFilename();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetMsgTransferFilename(IN const Bts2Ipc_GetMsgTransferFilename& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetMsgTransferFilename& operator=(IN const Bts2Ipc_GetMsgTransferFilename& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetMsgTransferFilename();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //genivi
} //btstackif

#endif //_BTS_2_IPC_MESSAGING_MSG_GENIVI_H_
