/**
 * @file Bts2Ipc_Connection_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_CONNECTION.
 */

#ifndef _BTS_2_IPC_CONNECTION_MSG_GENIVI_H_
#define _BTS_2_IPC_CONNECTION_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Bts2Ipc_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Bts2Ipc_GetManagedObjectsConnection : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetManagedObjectsConnection();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetManagedObjectsConnection(IN const Bts2Ipc_GetManagedObjectsConnection& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetManagedObjectsConnection& operator=(IN const Bts2Ipc_GetManagedObjectsConnection& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetManagedObjectsConnection();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetAllPropertiesConnection : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAllPropertiesConnection();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAllPropertiesConnection(IN const Bts2Ipc_GetAllPropertiesConnection& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAllPropertiesConnection& operator=(IN const Bts2Ipc_GetAllPropertiesConnection& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAllPropertiesConnection();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }
   inline void setInterface(IN const ::ccdbusif::evolution::Interface interface) { _interface = interface; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }
   inline ::ccdbusif::evolution::Interface getInterface(void) const { return _interface; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
   ::ccdbusif::evolution::Interface _interface; /**< parameter interface */
};

/**
 *
 */
class Bts2Ipc_GetIntrospectionConnection : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetIntrospectionConnection();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetIntrospectionConnection(IN const Bts2Ipc_GetIntrospectionConnection& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetIntrospectionConnection& operator=(IN const Bts2Ipc_GetIntrospectionConnection& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetIntrospectionConnection();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_ReleaseRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_ReleaseRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_ReleaseRes(IN const Bts2Ipc_ReleaseRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_ReleaseRes& operator=(IN const Bts2Ipc_ReleaseRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_ReleaseRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_RequestPinCodeRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RequestPinCodeRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RequestPinCodeRes(IN const Bts2Ipc_RequestPinCodeRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RequestPinCodeRes& operator=(IN const Bts2Ipc_RequestPinCodeRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RequestPinCodeRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setPinCode(IN const BTSPinCode& pinCode) { _pinCode = pinCode; }

   inline void getPinCode(OUT BTSPinCode& pinCode) const { pinCode = _pinCode; }
   inline const BTSPinCode& getPinCode(void) const { return _pinCode; }
   inline BTSPinCode& getPinCodeMutable(void) { return _pinCode; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSPinCode _pinCode; /**< parameter pin code */
};

/**
 *
 */
class Bts2Ipc_DisplayPinCodeRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_DisplayPinCodeRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_DisplayPinCodeRes(IN const Bts2Ipc_DisplayPinCodeRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_DisplayPinCodeRes& operator=(IN const Bts2Ipc_DisplayPinCodeRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_DisplayPinCodeRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2Ipc_RequestPasskeyRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RequestPasskeyRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RequestPasskeyRes(IN const Bts2Ipc_RequestPasskeyRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RequestPasskeyRes& operator=(IN const Bts2Ipc_RequestPasskeyRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RequestPasskeyRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setPasskey(IN const BTSNumericValue& passkey) { _passkey = passkey; }

   inline void getPasskey(OUT BTSNumericValue& passkey) const { passkey = _passkey; }
   inline const BTSNumericValue& getPasskey(void) const { return _passkey; }
   inline BTSNumericValue& getPasskeyMutable(void) { return _passkey; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSNumericValue _passkey; /**< parameter passkey */
};

/**
 *
 */
class Bts2Ipc_RequestConfirmationRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RequestConfirmationRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RequestConfirmationRes(IN const Bts2Ipc_RequestConfirmationRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RequestConfirmationRes& operator=(IN const Bts2Ipc_RequestConfirmationRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RequestConfirmationRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAccept(IN const BTSConfirmationMode accept) { _accept = accept; }

   inline BTSConfirmationMode getAccept(void) const { return _accept; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSConfirmationMode _accept; /**< parameter accept */
};

/**
 *
 */
class Bts2Ipc_CancelRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CancelRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CancelRes(IN const Bts2Ipc_CancelRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CancelRes& operator=(IN const Bts2Ipc_CancelRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CancelRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_CancelRequestRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CancelRequestRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CancelRequestRes(IN const Bts2Ipc_CancelRequestRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CancelRequestRes& operator=(IN const Bts2Ipc_CancelRequestRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CancelRequestRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_AuthorizeServiceRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_AuthorizeServiceRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_AuthorizeServiceRes(IN const Bts2Ipc_AuthorizeServiceRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_AuthorizeServiceRes& operator=(IN const Bts2Ipc_AuthorizeServiceRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_AuthorizeServiceRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAccept(IN const BTSConfirmationMode accept) { _accept = accept; }

   inline BTSConfirmationMode getAccept(void) const { return _accept; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSConfirmationMode _accept; /**< parameter accept */
};

/**
 *
 */
class Bts2Ipc_RequestAuthorizationRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RequestAuthorizationRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RequestAuthorizationRes(IN const Bts2Ipc_RequestAuthorizationRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RequestAuthorizationRes& operator=(IN const Bts2Ipc_RequestAuthorizationRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RequestAuthorizationRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAccept(IN const BTSConfirmationMode accept) { _accept = accept; }

   inline BTSConfirmationMode getAccept(void) const { return _accept; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSConfirmationMode _accept; /**< parameter accept */
};

/**
 *
 */
class Bts2Ipc_RequestLinkkeyRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RequestLinkkeyRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RequestLinkkeyRes(IN const Bts2Ipc_RequestLinkkeyRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RequestLinkkeyRes& operator=(IN const Bts2Ipc_RequestLinkkeyRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RequestLinkkeyRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setLinkKey(IN const BTSLinkKey& linkKey) { _linkKey = linkKey; }

   inline void getLinkKey(OUT BTSLinkKey& linkKey) const { linkKey = _linkKey; }
   inline const BTSLinkKey& getLinkKey(void) const { return _linkKey; }
   inline BTSLinkKey& getLinkKeyMutable(void) { return _linkKey; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSLinkKey _linkKey; /**< parameter link key */
};

/**
 *
 */
class Bts2Ipc_DisplayPasskeyRes : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_DisplayPasskeyRes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_DisplayPasskeyRes(IN const Bts2Ipc_DisplayPasskeyRes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_DisplayPasskeyRes& operator=(IN const Bts2Ipc_DisplayPasskeyRes& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_DisplayPasskeyRes();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2Ipc_StartDiscovery : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_StartDiscovery();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_StartDiscovery(IN const Bts2Ipc_StartDiscovery& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_StartDiscovery& operator=(IN const Bts2Ipc_StartDiscovery& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_StartDiscovery();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_StopDiscovery : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_StopDiscovery();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_StopDiscovery(IN const Bts2Ipc_StopDiscovery& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_StopDiscovery& operator=(IN const Bts2Ipc_StopDiscovery& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_StopDiscovery();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_RemoveDevice : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RemoveDevice();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RemoveDevice(IN const Bts2Ipc_RemoveDevice& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RemoveDevice& operator=(IN const Bts2Ipc_RemoveDevice& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RemoveDevice();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_CreateDevice : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CreateDevice();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CreateDevice(IN const Bts2Ipc_CreateDevice& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CreateDevice& operator=(IN const Bts2Ipc_CreateDevice& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CreateDevice();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2Ipc_SendHCICmd : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SendHCICmd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SendHCICmd(IN const Bts2Ipc_SendHCICmd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SendHCICmd& operator=(IN const Bts2Ipc_SendHCICmd& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SendHCICmd();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setLength(IN const BTSHciLength length) { _length = length; }
   inline void setData(IN const BTSHciData& data) { _data = data; }

   inline BTSHciLength getLength(void) const { return _length; }
   inline void getData(OUT BTSHciData& data) const { data = _data; }
   inline const BTSHciData& getData(void) const { return _data; }
   inline BTSHciData& getDataMutable(void) { return _data; }

private:
   BTSHciLength _length; /**< parameter length */
   BTSHciData _data; /**< parameter data */
};

/**
 *
 */
class Bts2Ipc_GetAdapterAddress : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterAddress();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterAddress(IN const Bts2Ipc_GetAdapterAddress& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterAddress& operator=(IN const Bts2Ipc_GetAdapterAddress& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterAddress();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetAdapterClass : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterClass();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterClass(IN const Bts2Ipc_GetAdapterClass& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterClass& operator=(IN const Bts2Ipc_GetAdapterClass& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterClass();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetAdapterAlias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterAlias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterAlias(IN const Bts2Ipc_GetAdapterAlias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterAlias& operator=(IN const Bts2Ipc_GetAdapterAlias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterAlias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterAlias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterAlias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterAlias(IN const Bts2Ipc_SetAdapterAlias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterAlias& operator=(IN const Bts2Ipc_SetAdapterAlias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterAlias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAlias(IN const BTSDeviceName& alias) { _alias = alias; }

   inline void getAlias(OUT BTSDeviceName& alias) const { alias = _alias; }
   inline const BTSDeviceName& getAlias(void) const { return _alias; }
   inline BTSDeviceName& getAliasMutable(void) { return _alias; }

private:
   BTSDeviceName _alias; /**< parameter alias */
};

/**
 *
 */
class Bts2Ipc_GetAdapterPowered : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterPowered();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterPowered(IN const Bts2Ipc_GetAdapterPowered& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterPowered& operator=(IN const Bts2Ipc_GetAdapterPowered& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterPowered();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterPowered : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterPowered();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterPowered(IN const Bts2Ipc_SetAdapterPowered& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterPowered& operator=(IN const Bts2Ipc_SetAdapterPowered& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterPowered();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setPowered(IN const bool powered) { _powered = powered; }

   inline bool getPowered(void) const { return _powered; }

private:
   bool _powered; /**< parameter powered */
};

/**
 *
 */
class Bts2Ipc_GetAdapterDiscoverable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterDiscoverable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterDiscoverable(IN const Bts2Ipc_GetAdapterDiscoverable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterDiscoverable& operator=(IN const Bts2Ipc_GetAdapterDiscoverable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterDiscoverable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterDiscoverable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterDiscoverable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterDiscoverable(IN const Bts2Ipc_SetAdapterDiscoverable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterDiscoverable& operator=(IN const Bts2Ipc_SetAdapterDiscoverable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterDiscoverable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDiscoverable(IN const bool discoverable) { _discoverable = discoverable; }

   inline bool getDiscoverable(void) const { return _discoverable; }

private:
   bool _discoverable; /**< parameter discoverable */
};

/**
 *
 */
class Bts2Ipc_GetAdapterDiscoverabletimeout : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterDiscoverabletimeout();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterDiscoverabletimeout(IN const Bts2Ipc_GetAdapterDiscoverabletimeout& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterDiscoverabletimeout& operator=(IN const Bts2Ipc_GetAdapterDiscoverabletimeout& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterDiscoverabletimeout();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterDiscoverabletimeout : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterDiscoverabletimeout();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterDiscoverabletimeout(IN const Bts2Ipc_SetAdapterDiscoverabletimeout& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterDiscoverabletimeout& operator=(IN const Bts2Ipc_SetAdapterDiscoverabletimeout& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterDiscoverabletimeout();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDiscoverableTimeout(IN const BTSDiscoverableTimeout discoverableTimeout) { _discoverableTimeout = discoverableTimeout; }

   inline BTSDiscoverableTimeout getDiscoverableTimeout(void) const { return _discoverableTimeout; }

private:
   BTSDiscoverableTimeout _discoverableTimeout; /**< parameter discoverable timeout */
};

/**
 *
 */
class Bts2Ipc_GetAdapterPairable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterPairable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterPairable(IN const Bts2Ipc_GetAdapterPairable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterPairable& operator=(IN const Bts2Ipc_GetAdapterPairable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterPairable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterPairable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterPairable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterPairable(IN const Bts2Ipc_SetAdapterPairable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterPairable& operator=(IN const Bts2Ipc_SetAdapterPairable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterPairable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setPairable(IN const bool pairable) { _pairable = pairable; }

   inline bool getPairable(void) const { return _pairable; }

private:
   bool _pairable; /**< parameter pairable */
};

/**
 *
 */
class Bts2Ipc_GetAdapterPairabletimeout : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterPairabletimeout();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterPairabletimeout(IN const Bts2Ipc_GetAdapterPairabletimeout& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterPairabletimeout& operator=(IN const Bts2Ipc_GetAdapterPairabletimeout& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterPairabletimeout();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterPairabletimeout : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterPairabletimeout();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterPairabletimeout(IN const Bts2Ipc_SetAdapterPairabletimeout& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterPairabletimeout& operator=(IN const Bts2Ipc_SetAdapterPairabletimeout& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterPairabletimeout();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setPairableTimeout(IN const BTSPairableTimeout pairableTimeout) { _pairableTimeout = pairableTimeout; }

   inline BTSPairableTimeout getPairableTimeout(void) const { return _pairableTimeout; }

private:
   BTSPairableTimeout _pairableTimeout; /**< parameter pairable timeout */
};

/**
 *
 */
class Bts2Ipc_GetAdapterDiscovering : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterDiscovering();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterDiscovering(IN const Bts2Ipc_GetAdapterDiscovering& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterDiscovering& operator=(IN const Bts2Ipc_GetAdapterDiscovering& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterDiscovering();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetAdapterUuids : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterUuids();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterUuids(IN const Bts2Ipc_GetAdapterUuids& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterUuids& operator=(IN const Bts2Ipc_GetAdapterUuids& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterUuids();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterUuids : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterUuids();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterUuids(IN const Bts2Ipc_SetAdapterUuids& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterUuids& operator=(IN const Bts2Ipc_SetAdapterUuids& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterUuids();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setUuids(IN const BTSUuidList& uuids) { _uuids = uuids; }

   inline void getUuids(OUT BTSUuidList& uuids) const { uuids = _uuids; }
   inline const BTSUuidList& getUuids(void) const { return _uuids; }
   inline BTSUuidList& getUuidsMutable(void) { return _uuids; }

private:
   BTSUuidList _uuids; /**< parameter uuids */
};

/**
 *
 */
class Bts2Ipc_GetAdapterWbsMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterWbsMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterWbsMode(IN const Bts2Ipc_GetAdapterWbsMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterWbsMode& operator=(IN const Bts2Ipc_GetAdapterWbsMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterWbsMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterWbsMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterWbsMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterWbsMode(IN const Bts2Ipc_SetAdapterWbsMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterWbsMode& operator=(IN const Bts2Ipc_SetAdapterWbsMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterWbsMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setWbsMode(IN const bool wbsMode) { _wbsMode = wbsMode; }

   inline bool getWbsMode(void) const { return _wbsMode; }

private:
   bool _wbsMode; /**< parameter wbs mode */
};

/**
 *
 */
class Bts2Ipc_GetAdapterConnectable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterConnectable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterConnectable(IN const Bts2Ipc_GetAdapterConnectable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterConnectable& operator=(IN const Bts2Ipc_GetAdapterConnectable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterConnectable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterConnectable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterConnectable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterConnectable(IN const Bts2Ipc_SetAdapterConnectable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterConnectable& operator=(IN const Bts2Ipc_SetAdapterConnectable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterConnectable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setConnectable(IN const bool connectable) { _connectable = connectable; }

   inline bool getConnectable(void) const { return _connectable; }

private:
   bool _connectable; /**< parameter connectable */
};

/**
 *
 */
class Bts2Ipc_GetAdapterHcimode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterHcimode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterHcimode(IN const Bts2Ipc_GetAdapterHcimode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterHcimode& operator=(IN const Bts2Ipc_GetAdapterHcimode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterHcimode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterHcimode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterHcimode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterHcimode(IN const Bts2Ipc_SetAdapterHcimode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterHcimode& operator=(IN const Bts2Ipc_SetAdapterHcimode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterHcimode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setHciMode(IN const bool hciMode) { _hciMode = hciMode; }

   inline bool getHciMode(void) const { return _hciMode; }

private:
   bool _hciMode; /**< parameter hci mode */
};

/**
 *
 */
class Bts2Ipc_GetAdapterVersion : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterVersion();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterVersion(IN const Bts2Ipc_GetAdapterVersion& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterVersion& operator=(IN const Bts2Ipc_GetAdapterVersion& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterVersion();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetAdapterTraceLevel : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterTraceLevel();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterTraceLevel(IN const Bts2Ipc_GetAdapterTraceLevel& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterTraceLevel& operator=(IN const Bts2Ipc_GetAdapterTraceLevel& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterTraceLevel();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterTraceLevel : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterTraceLevel();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterTraceLevel(IN const Bts2Ipc_SetAdapterTraceLevel& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterTraceLevel& operator=(IN const Bts2Ipc_SetAdapterTraceLevel& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterTraceLevel();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setTraceLevel(IN const BTSGeniviTraceLevel& traceLevel) { _traceLevel = traceLevel; }

   inline void getTraceLevel(OUT BTSGeniviTraceLevel& traceLevel) const { traceLevel = _traceLevel; }
   inline const BTSGeniviTraceLevel& getTraceLevel(void) const { return _traceLevel; }
   inline BTSGeniviTraceLevel& getTraceLevelMutable(void) { return _traceLevel; }

private:
   BTSGeniviTraceLevel _traceLevel; /**< parameter trace level */
};

/**
 *
 */
class Bts2Ipc_GetAdapterTraceCategory : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterTraceCategory();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterTraceCategory(IN const Bts2Ipc_GetAdapterTraceCategory& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterTraceCategory& operator=(IN const Bts2Ipc_GetAdapterTraceCategory& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterTraceCategory();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterTraceCategory : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterTraceCategory();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterTraceCategory(IN const Bts2Ipc_SetAdapterTraceCategory& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterTraceCategory& operator=(IN const Bts2Ipc_SetAdapterTraceCategory& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterTraceCategory();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setTraceCategory(IN const BTSGeniviTraceCategory& traceCategory) { _traceCategory = traceCategory; }

   inline void getTraceCategory(OUT BTSGeniviTraceCategory& traceCategory) const { traceCategory = _traceCategory; }
   inline const BTSGeniviTraceCategory& getTraceCategory(void) const { return _traceCategory; }
   inline BTSGeniviTraceCategory& getTraceCategoryMutable(void) { return _traceCategory; }

private:
   BTSGeniviTraceCategory _traceCategory; /**< parameter trace category */
};

/**
 *
 */
class Bts2Ipc_GetAdapterAvailableSppServers : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAdapterAvailableSppServers();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAdapterAvailableSppServers(IN const Bts2Ipc_GetAdapterAvailableSppServers& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAdapterAvailableSppServers& operator=(IN const Bts2Ipc_GetAdapterAvailableSppServers& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAdapterAvailableSppServers();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetAdapterAvailableSppServers : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetAdapterAvailableSppServers();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetAdapterAvailableSppServers(IN const Bts2Ipc_SetAdapterAvailableSppServers& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetAdapterAvailableSppServers& operator=(IN const Bts2Ipc_SetAdapterAvailableSppServers& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetAdapterAvailableSppServers();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAvailableSppServers(IN const BTSUuidList& availableSppServers) { _availableSppServers = availableSppServers; }

   inline void getAvailableSppServers(OUT BTSUuidList& availableSppServers) const { availableSppServers = _availableSppServers; }
   inline const BTSUuidList& getAvailableSppServers(void) const { return _availableSppServers; }
   inline BTSUuidList& getAvailableSppServersMutable(void) { return _availableSppServers; }

private:
   BTSUuidList _availableSppServers; /**< parameter available spp servers */
};

/**
 *
 */
class Bts2Ipc_RegisterAgent : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RegisterAgent();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RegisterAgent(IN const Bts2Ipc_RegisterAgent& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RegisterAgent& operator=(IN const Bts2Ipc_RegisterAgent& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RegisterAgent();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAgent(IN const BTSObjectPath& agent) { _agent = agent; }
   inline void setCapability(IN const BTSAgentCapability capability) { _capability = capability; }

   inline void getAgent(OUT BTSObjectPath& agent) const { agent = _agent; }
   inline const BTSObjectPath& getAgent(void) const { return _agent; }
   inline BTSObjectPath& getAgentMutable(void) { return _agent; }
   inline BTSAgentCapability getCapability(void) const { return _capability; }

private:
   BTSObjectPath _agent; /**< parameter agent */
   BTSAgentCapability _capability; /**< parameter capability */
};

/**
 *
 */
class Bts2Ipc_UnregisterAgent : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_UnregisterAgent();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_UnregisterAgent(IN const Bts2Ipc_UnregisterAgent& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_UnregisterAgent& operator=(IN const Bts2Ipc_UnregisterAgent& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_UnregisterAgent();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAgent(IN const BTSObjectPath& agent) { _agent = agent; }

   inline void getAgent(OUT BTSObjectPath& agent) const { agent = _agent; }
   inline const BTSObjectPath& getAgent(void) const { return _agent; }
   inline BTSObjectPath& getAgentMutable(void) { return _agent; }

private:
   BTSObjectPath _agent; /**< parameter agent */
};

/**
 *
 */
class Bts2Ipc_RequestDefaultAgent : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RequestDefaultAgent();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RequestDefaultAgent(IN const Bts2Ipc_RequestDefaultAgent& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RequestDefaultAgent& operator=(IN const Bts2Ipc_RequestDefaultAgent& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RequestDefaultAgent();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAgent(IN const BTSObjectPath& agent) { _agent = agent; }

   inline void getAgent(OUT BTSObjectPath& agent) const { agent = _agent; }
   inline const BTSObjectPath& getAgent(void) const { return _agent; }
   inline BTSObjectPath& getAgentMutable(void) { return _agent; }

private:
   BTSObjectPath _agent; /**< parameter agent */
};

/**
 *
 */
class Bts2Ipc_DeviceConnect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_DeviceConnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_DeviceConnect(IN const Bts2Ipc_DeviceConnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_DeviceConnect& operator=(IN const Bts2Ipc_DeviceConnect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_DeviceConnect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_DeviceDisconnect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_DeviceDisconnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_DeviceDisconnect(IN const Bts2Ipc_DeviceDisconnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_DeviceDisconnect& operator=(IN const Bts2Ipc_DeviceDisconnect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_DeviceDisconnect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_Pair : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_Pair();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_Pair(IN const Bts2Ipc_Pair& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_Pair& operator=(IN const Bts2Ipc_Pair& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_Pair();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_CancelPairing : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CancelPairing();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CancelPairing(IN const Bts2Ipc_CancelPairing& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CancelPairing& operator=(IN const Bts2Ipc_CancelPairing& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CancelPairing();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_DiscoverServices : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_DiscoverServices();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_DiscoverServices(IN const Bts2Ipc_DiscoverServices& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_DiscoverServices& operator=(IN const Bts2Ipc_DiscoverServices& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_DiscoverServices();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setSearchType(IN const BTSSearchType searchType) { _searchType = searchType; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSSearchType getSearchType(void) const { return _searchType; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSSearchType _searchType; /**< parameter search type */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_CancelDiscovery : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CancelDiscovery();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CancelDiscovery(IN const Bts2Ipc_CancelDiscovery& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CancelDiscovery& operator=(IN const Bts2Ipc_CancelDiscovery& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CancelDiscovery();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceAddress : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceAddress();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceAddress(IN const Bts2Ipc_GetDeviceAddress& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceAddress& operator=(IN const Bts2Ipc_GetDeviceAddress& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceAddress();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceClass : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceClass();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceClass(IN const Bts2Ipc_GetDeviceClass& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceClass& operator=(IN const Bts2Ipc_GetDeviceClass& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceClass();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceIcon : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceIcon();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceIcon(IN const Bts2Ipc_GetDeviceIcon& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceIcon& operator=(IN const Bts2Ipc_GetDeviceIcon& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceIcon();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceUuids : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceUuids();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceUuids(IN const Bts2Ipc_GetDeviceUuids& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceUuids& operator=(IN const Bts2Ipc_GetDeviceUuids& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceUuids();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDevicePaired : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDevicePaired();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDevicePaired(IN const Bts2Ipc_GetDevicePaired& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDevicePaired& operator=(IN const Bts2Ipc_GetDevicePaired& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDevicePaired();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceConnected : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceConnected();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceConnected(IN const Bts2Ipc_GetDeviceConnected& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceConnected& operator=(IN const Bts2Ipc_GetDeviceConnected& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceConnected();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceTrusted : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceTrusted();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceTrusted(IN const Bts2Ipc_GetDeviceTrusted& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceTrusted& operator=(IN const Bts2Ipc_GetDeviceTrusted& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceTrusted();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SetDeviceTrusted : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetDeviceTrusted();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetDeviceTrusted(IN const Bts2Ipc_SetDeviceTrusted& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetDeviceTrusted& operator=(IN const Bts2Ipc_SetDeviceTrusted& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetDeviceTrusted();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setTrusted(IN const bool trusted) { _trusted = trusted; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getTrusted(void) const { return _trusted; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   bool _trusted; /**< parameter trusted */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceBlocked : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceBlocked();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceBlocked(IN const Bts2Ipc_GetDeviceBlocked& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceBlocked& operator=(IN const Bts2Ipc_GetDeviceBlocked& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceBlocked();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SetDeviceBlocked : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetDeviceBlocked();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetDeviceBlocked(IN const Bts2Ipc_SetDeviceBlocked& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetDeviceBlocked& operator=(IN const Bts2Ipc_SetDeviceBlocked& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetDeviceBlocked();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBlocked(IN const bool blocked) { _blocked = blocked; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getBlocked(void) const { return _blocked; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   bool _blocked; /**< parameter blocked */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceAlias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceAlias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceAlias(IN const Bts2Ipc_GetDeviceAlias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceAlias& operator=(IN const Bts2Ipc_GetDeviceAlias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceAlias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SetDeviceAlias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetDeviceAlias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetDeviceAlias(IN const Bts2Ipc_SetDeviceAlias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetDeviceAlias& operator=(IN const Bts2Ipc_SetDeviceAlias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetDeviceAlias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setAlias(IN const BTSDeviceName& alias) { _alias = alias; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getAlias(OUT BTSDeviceName& alias) const { alias = _alias; }
   inline const BTSDeviceName& getAlias(void) const { return _alias; }
   inline BTSDeviceName& getAliasMutable(void) { return _alias; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
   BTSDeviceName _alias; /**< parameter alias */
};

/**
 *
 */
class Bts2Ipc_GetDeviceAdapter : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceAdapter();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceAdapter(IN const Bts2Ipc_GetDeviceAdapter& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceAdapter& operator=(IN const Bts2Ipc_GetDeviceAdapter& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceAdapter();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceModalias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceModalias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceModalias(IN const Bts2Ipc_GetDeviceModalias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceModalias& operator=(IN const Bts2Ipc_GetDeviceModalias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceModalias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceRssi : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceRssi();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceRssi(IN const Bts2Ipc_GetDeviceRssi& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceRssi& operator=(IN const Bts2Ipc_GetDeviceRssi& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceRssi();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceVendorId : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceVendorId();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceVendorId(IN const Bts2Ipc_GetDeviceVendorId& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceVendorId& operator=(IN const Bts2Ipc_GetDeviceVendorId& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceVendorId();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceVendorIdSource : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceVendorIdSource();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceVendorIdSource(IN const Bts2Ipc_GetDeviceVendorIdSource& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceVendorIdSource& operator=(IN const Bts2Ipc_GetDeviceVendorIdSource& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceVendorIdSource();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceProductId : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceProductId();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceProductId(IN const Bts2Ipc_GetDeviceProductId& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceProductId& operator=(IN const Bts2Ipc_GetDeviceProductId& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceProductId();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceMapInfo : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceMapInfo();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceMapInfo(IN const Bts2Ipc_GetDeviceMapInfo& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceMapInfo& operator=(IN const Bts2Ipc_GetDeviceMapInfo& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceMapInfo();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceConnectedService : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceConnectedService();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceConnectedService(IN const Bts2Ipc_GetDeviceConnectedService& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceConnectedService& operator=(IN const Bts2Ipc_GetDeviceConnectedService& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceConnectedService();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceVersion : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceVersion();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceVersion(IN const Bts2Ipc_GetDeviceVersion& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceVersion& operator=(IN const Bts2Ipc_GetDeviceVersion& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceVersion();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDevicePbapInfo : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDevicePbapInfo();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDevicePbapInfo(IN const Bts2Ipc_GetDevicePbapInfo& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDevicePbapInfo& operator=(IN const Bts2Ipc_GetDevicePbapInfo& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDevicePbapInfo();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceMode(IN const Bts2Ipc_GetDeviceMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceMode& operator=(IN const Bts2Ipc_GetDeviceMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceRole : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceRole();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceRole(IN const Bts2Ipc_GetDeviceRole& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceRole& operator=(IN const Bts2Ipc_GetDeviceRole& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceRole();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetDeviceEnableAvpPause : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDeviceEnableAvpPause();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDeviceEnableAvpPause(IN const Bts2Ipc_GetDeviceEnableAvpPause& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDeviceEnableAvpPause& operator=(IN const Bts2Ipc_GetDeviceEnableAvpPause& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDeviceEnableAvpPause();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SetDeviceEnableAvpPause : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetDeviceEnableAvpPause();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetDeviceEnableAvpPause(IN const Bts2Ipc_SetDeviceEnableAvpPause& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetDeviceEnableAvpPause& operator=(IN const Bts2Ipc_SetDeviceEnableAvpPause& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetDeviceEnableAvpPause();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setEnableAvpPause(IN const bool enableAvpPause) { _enableAvpPause = enableAvpPause; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getEnableAvpPause(void) const { return _enableAvpPause; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   bool _enableAvpPause; /**< parameter enable avp pause */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_BtApplDeviceConnectReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplDeviceConnectReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplDeviceConnectReq(IN const Bts2Ipc_BtApplDeviceConnectReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplDeviceConnectReq& operator=(IN const Bts2Ipc_BtApplDeviceConnectReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplDeviceConnectReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setServiceFunction(IN const BTSServiceFunction& serviceFunction) { _serviceFunction = serviceFunction; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }

   inline void getServiceFunction(OUT BTSServiceFunction& serviceFunction) const { serviceFunction = _serviceFunction; }
   inline const BTSServiceFunction& getServiceFunction(void) const { return _serviceFunction; }
   inline BTSServiceFunction& getServiceFunctionMutable(void) { return _serviceFunction; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSServiceFunction _serviceFunction; /**< parameter service function */
   BTSInstanceIndex _instance; /**< parameter instance */
};

/**
 *
 */
class Bts2Ipc_BtApplDeviceDisconnectReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplDeviceDisconnectReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplDeviceDisconnectReq(IN const Bts2Ipc_BtApplDeviceDisconnectReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplDeviceDisconnectReq& operator=(IN const Bts2Ipc_BtApplDeviceDisconnectReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplDeviceDisconnectReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setServiceFunction(IN const BTSServiceFunction& serviceFunction) { _serviceFunction = serviceFunction; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }

   inline void getServiceFunction(OUT BTSServiceFunction& serviceFunction) const { serviceFunction = _serviceFunction; }
   inline const BTSServiceFunction& getServiceFunction(void) const { return _serviceFunction; }
   inline BTSServiceFunction& getServiceFunctionMutable(void) { return _serviceFunction; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSServiceFunction _serviceFunction; /**< parameter service function */
   BTSInstanceIndex _instance; /**< parameter instance */
};

/**
 *
 */
class Bts2Ipc_BtApplCancelConnectReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplCancelConnectReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplCancelConnectReq(IN const Bts2Ipc_BtApplCancelConnectReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplCancelConnectReq& operator=(IN const Bts2Ipc_BtApplCancelConnectReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplCancelConnectReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2Ipc_BtApplGetHwVersionReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplGetHwVersionReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplGetHwVersionReq(IN const Bts2Ipc_BtApplGetHwVersionReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplGetHwVersionReq& operator=(IN const Bts2Ipc_BtApplGetHwVersionReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplGetHwVersionReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_BtApplSetConfigurationReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplSetConfigurationReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplSetConfigurationReq(IN const Bts2Ipc_BtApplSetConfigurationReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplSetConfigurationReq& operator=(IN const Bts2Ipc_BtApplSetConfigurationReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplSetConfigurationReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setConfigId(IN const BTSEvoConfigIdEnum configId) { _configId = configId; }
   inline void setData(IN const BTSEvoConfigDataStream& data) { _data = data; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSEvoConfigIdEnum getConfigId(void) const { return _configId; }
   inline void getData(OUT BTSEvoConfigDataStream& data) const { data = _data; }
   inline const BTSEvoConfigDataStream& getData(void) const { return _data; }
   inline BTSEvoConfigDataStream& getDataMutable(void) { return _data; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSEvoConfigIdEnum _configId; /**< parameter config id */
   BTSEvoConfigDataStream _data; /**< parameter data */
};

/**
 *
 */
class Bts2Ipc_BtApplReadConfigurationReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplReadConfigurationReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplReadConfigurationReq(IN const Bts2Ipc_BtApplReadConfigurationReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplReadConfigurationReq& operator=(IN const Bts2Ipc_BtApplReadConfigurationReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplReadConfigurationReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setConfigId(IN const BTSEvoConfigIdEnum configId) { _configId = configId; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSEvoConfigIdEnum getConfigId(void) const { return _configId; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSEvoConfigIdEnum _configId; /**< parameter config id */
};

/**
 *
 */
class Bts2Ipc_BtApplTestModeReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplTestModeReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplTestModeReq(IN const Bts2Ipc_BtApplTestModeReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplTestModeReq& operator=(IN const Bts2Ipc_BtApplTestModeReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplTestModeReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setEnable(IN const bool enable) { _enable = enable; }
   inline void setMode(IN const BTSTestMode mode) { _mode = mode; }
   inline void setRole(IN const BTSBtRole role) { _role = role; }

   inline bool getEnable(void) const { return _enable; }
   inline BTSTestMode getMode(void) const { return _mode; }
   inline BTSBtRole getRole(void) const { return _role; }

private:
   bool _enable; /**< parameter enable */
   BTSTestMode _mode; /**< parameter mode */
   BTSBtRole _role; /**< parameter role */
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2Ipc_BtApplTestModeLinkQualityReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplTestModeLinkQualityReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplTestModeLinkQualityReq(IN const Bts2Ipc_BtApplTestModeLinkQualityReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplTestModeLinkQualityReq& operator=(IN const Bts2Ipc_BtApplTestModeLinkQualityReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplTestModeLinkQualityReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setMode(IN const BTSTestMode mode) { _mode = mode; }

   inline BTSTestMode getMode(void) const { return _mode; }

private:
   BTSTestMode _mode; /**< parameter mode */
};

/**
 *
 */
class Bts2Ipc_Connect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_Connect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_Connect(IN const Bts2Ipc_Connect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_Connect& operator=(IN const Bts2Ipc_Connect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_Connect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Bts2Ipc_Disconnect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_Disconnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_Disconnect(IN const Bts2Ipc_Disconnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_Disconnect& operator=(IN const Bts2Ipc_Disconnect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_Disconnect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Bts2Ipc_GetServiceRemoteUuid : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetServiceRemoteUuid();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetServiceRemoteUuid(IN const Bts2Ipc_GetServiceRemoteUuid& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetServiceRemoteUuid& operator=(IN const Bts2Ipc_GetServiceRemoteUuid& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetServiceRemoteUuid();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Bts2Ipc_GetServiceState : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetServiceState();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetServiceState(IN const Bts2Ipc_GetServiceState& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetServiceState& operator=(IN const Bts2Ipc_GetServiceState& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetServiceState();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Bts2Ipc_GetServiceDevice : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetServiceDevice();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetServiceDevice(IN const Bts2Ipc_GetServiceDevice& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetServiceDevice& operator=(IN const Bts2Ipc_GetServiceDevice& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetServiceDevice();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Bts2Ipc_GetServiceVersion : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetServiceVersion();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetServiceVersion(IN const Bts2Ipc_GetServiceVersion& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetServiceVersion& operator=(IN const Bts2Ipc_GetServiceVersion& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetServiceVersion();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Bts2Ipc_DebugTraceConfig : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_DebugTraceConfig();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_DebugTraceConfig(IN const Bts2Ipc_DebugTraceConfig& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_DebugTraceConfig& operator=(IN const Bts2Ipc_DebugTraceConfig& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_DebugTraceConfig();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setTraceLevel(IN const BTSDebugTraceLevel traceLevel) { _traceLevel = traceLevel; }
   inline void setCurrentTime(IN const BTSDebugTime currentTime) { _currentTime = currentTime; }
   inline void setTraceMode(IN const BTSDebugTraceMode traceMode) { _traceMode = traceMode; }
   inline void setCategory1(IN const BTSDebugBtAppCategory category1) { _category1 = category1; }
   inline void setCategory2(IN const BTSDebugBtStackCategory category2) { _category2 = category2; }
   inline void setCategory3(IN const BTSDebugReservedCategory category3) { _category3 = category3; }

   inline BTSDebugTraceLevel getTraceLevel(void) const { return _traceLevel; }
   inline BTSDebugTime getCurrentTime(void) const { return _currentTime; }
   inline BTSDebugTraceMode getTraceMode(void) const { return _traceMode; }
   inline BTSDebugBtAppCategory getCategory1(void) const { return _category1; }
   inline BTSDebugBtStackCategory getCategory2(void) const { return _category2; }
   inline BTSDebugReservedCategory getCategory3(void) const { return _category3; }

private:
   BTSDebugTraceLevel _traceLevel; /**< parameter trace level */
   BTSDebugTime _currentTime; /**< parameter current time */
   BTSDebugTraceMode _traceMode; /**< parameter trace mode */
   BTSDebugBtAppCategory _category1; /**< parameter category */
   BTSDebugBtStackCategory _category2; /**< parameter category */
   BTSDebugReservedCategory _category3; /**< parameter category */
};

/**
 *
 */
class Bts2Ipc_ProtocolTraceConfig : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_ProtocolTraceConfig();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_ProtocolTraceConfig(IN const Bts2Ipc_ProtocolTraceConfig& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_ProtocolTraceConfig& operator=(IN const Bts2Ipc_ProtocolTraceConfig& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_ProtocolTraceConfig();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setTraceFilter(IN const BTSDebugTraceFilter traceFilter) { _traceFilter = traceFilter; }

   inline BTSDebugTraceFilter getTraceFilter(void) const { return _traceFilter; }

private:
   BTSDebugTraceFilter _traceFilter; /**< parameter trace filter */
};

/**
 *
 */
class Bts2Ipc_BtApplDidSetReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplDidSetReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplDidSetReq(IN const Bts2Ipc_BtApplDidSetReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplDidSetReq& operator=(IN const Bts2Ipc_BtApplDidSetReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplDidSetReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setServiceRecord(IN const BTSDeviceIdServiceRecord& serviceRecord) { _serviceRecord = serviceRecord; }

   inline void getServiceRecord(OUT BTSDeviceIdServiceRecord& serviceRecord) const { serviceRecord = _serviceRecord; }
   inline const BTSDeviceIdServiceRecord& getServiceRecord(void) const { return _serviceRecord; }
   inline BTSDeviceIdServiceRecord& getServiceRecordMutable(void) { return _serviceRecord; }

private:
   BTSDeviceIdServiceRecord _serviceRecord; /**< parameter service record */
};

/**
 *
 */
class Bts2Ipc_GetDunDeviceFilePath : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetDunDeviceFilePath();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetDunDeviceFilePath(IN const Bts2Ipc_GetDunDeviceFilePath& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetDunDeviceFilePath& operator=(IN const Bts2Ipc_GetDunDeviceFilePath& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetDunDeviceFilePath();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_BtApplSppSetUuidReq : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_BtApplSppSetUuidReq();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_BtApplSppSetUuidReq(IN const Bts2Ipc_BtApplSppSetUuidReq& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_BtApplSppSetUuidReq& operator=(IN const Bts2Ipc_BtApplSppSetUuidReq& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_BtApplSppSetUuidReq();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setOutgoingUuid(IN const BTSUuid& outgoingUuid) { _outgoingUuid = outgoingUuid; }
   inline void setIncomingUuid(IN const BTSUuid& incomingUuid) { _incomingUuid = incomingUuid; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline void getOutgoingUuid(OUT BTSUuid& outgoingUuid) const { outgoingUuid = _outgoingUuid; }
   inline const BTSUuid& getOutgoingUuid(void) const { return _outgoingUuid; }
   inline BTSUuid& getOutgoingUuidMutable(void) { return _outgoingUuid; }
   inline void getIncomingUuid(OUT BTSUuid& incomingUuid) const { incomingUuid = _incomingUuid; }
   inline const BTSUuid& getIncomingUuid(void) const { return _incomingUuid; }
   inline BTSUuid& getIncomingUuidMutable(void) { return _incomingUuid; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSUuid _outgoingUuid; /**< parameter outgoing uuid */
   BTSUuid _incomingUuid; /**< parameter incoming uuid */
};

/**
 *
 */
class Bts2Ipc_CreateSession : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CreateSession();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CreateSession(IN const Bts2Ipc_CreateSession& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CreateSession& operator=(IN const Bts2Ipc_CreateSession& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CreateSession();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setSourceAddress(IN const BTSBDAddress& sourceAddress) { _sourceAddress = sourceAddress; }
   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setChannel(IN const BTSSessionChannel channel) { _channel = channel; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }

   inline void getSourceAddress(OUT BTSBDAddress& sourceAddress) const { sourceAddress = _sourceAddress; }
   inline const BTSBDAddress& getSourceAddress(void) const { return _sourceAddress; }
   inline BTSBDAddress& getSourceAddressMutable(void) { return _sourceAddress; }
   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline BTSSessionChannel getChannel(void) const { return _channel; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSBDAddress _sourceAddress; /**< parameter source address */
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSSessionChannel _channel; /**< parameter channel */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
};

/**
 *
 */
class Bts2Ipc_RemoveSession : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RemoveSession();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RemoveSession(IN const Bts2Ipc_RemoveSession& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RemoveSession& operator=(IN const Bts2Ipc_RemoveSession& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RemoveSession();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }
   inline void setSession(IN const BTSObjectPath& session) { _session = session; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }
   inline void getSession(OUT BTSObjectPath& session) const { session = _session; }
   inline const BTSObjectPath& getSession(void) const { return _session; }
   inline BTSObjectPath& getSessionMutable(void) { return _session; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
   BTSObjectPath _session; /**< parameter session */
};

/**
 *
 */
class Bts2Ipc_CancelSession : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CancelSession();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CancelSession(IN const Bts2Ipc_CancelSession& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CancelSession& operator=(IN const Bts2Ipc_CancelSession& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CancelSession();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setSourceAddress(IN const BTSBDAddress& sourceAddress) { _sourceAddress = sourceAddress; }
   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setChannel(IN const BTSSessionChannel channel) { _channel = channel; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }

   inline void getSourceAddress(OUT BTSBDAddress& sourceAddress) const { sourceAddress = _sourceAddress; }
   inline const BTSBDAddress& getSourceAddress(void) const { return _sourceAddress; }
   inline BTSBDAddress& getSourceAddressMutable(void) { return _sourceAddress; }
   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline BTSSessionChannel getChannel(void) const { return _channel; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSBDAddress _sourceAddress; /**< parameter source address */
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSSessionChannel _channel; /**< parameter channel */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
};

/**
 *
 */
class Bts2Ipc_GetConnManManagerProperties : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetConnManManagerProperties();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetConnManManagerProperties(IN const Bts2Ipc_GetConnManManagerProperties& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetConnManManagerProperties& operator=(IN const Bts2Ipc_GetConnManManagerProperties& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetConnManManagerProperties();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetConnManTechnologies : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetConnManTechnologies();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetConnManTechnologies(IN const Bts2Ipc_GetConnManTechnologies& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetConnManTechnologies& operator=(IN const Bts2Ipc_GetConnManTechnologies& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetConnManTechnologies();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetConnManServices : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetConnManServices();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetConnManServices(IN const Bts2Ipc_GetConnManServices& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetConnManServices& operator=(IN const Bts2Ipc_GetConnManServices& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetConnManServices();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetConnManServiceProperties : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetConnManServiceProperties();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetConnManServiceProperties(IN const Bts2Ipc_GetConnManServiceProperties& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetConnManServiceProperties& operator=(IN const Bts2Ipc_GetConnManServiceProperties& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetConnManServiceProperties();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_ConnManServiceConnect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_ConnManServiceConnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_ConnManServiceConnect(IN const Bts2Ipc_ConnManServiceConnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_ConnManServiceConnect& operator=(IN const Bts2Ipc_ConnManServiceConnect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_ConnManServiceConnect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_ConnManServiceDisconnect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_ConnManServiceDisconnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_ConnManServiceDisconnect(IN const Bts2Ipc_ConnManServiceDisconnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_ConnManServiceDisconnect& operator=(IN const Bts2Ipc_ConnManServiceDisconnect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_ConnManServiceDisconnect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_CreateLeDevice : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_CreateLeDevice();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_CreateLeDevice(IN const Bts2Ipc_CreateLeDevice& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_CreateLeDevice& operator=(IN const Bts2Ipc_CreateLeDevice& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_CreateLeDevice();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Bts2Ipc_RemoveLeDevice : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_RemoveLeDevice();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_RemoveLeDevice(IN const Bts2Ipc_RemoveLeDevice& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_RemoveLeDevice& operator=(IN const Bts2Ipc_RemoveLeDevice& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_RemoveLeDevice();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterAddressType : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterAddressType();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterAddressType(IN const Bts2Ipc_GetLeAdapterAddressType& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterAddressType& operator=(IN const Bts2Ipc_GetLeAdapterAddressType& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterAddressType();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterAddress : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterAddress();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterAddress(IN const Bts2Ipc_GetLeAdapterAddress& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterAddress& operator=(IN const Bts2Ipc_GetLeAdapterAddress& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterAddress();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterAlias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterAlias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterAlias(IN const Bts2Ipc_GetLeAdapterAlias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterAlias& operator=(IN const Bts2Ipc_GetLeAdapterAlias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterAlias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetLeAdapterAlias : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetLeAdapterAlias();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetLeAdapterAlias(IN const Bts2Ipc_SetLeAdapterAlias& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetLeAdapterAlias& operator=(IN const Bts2Ipc_SetLeAdapterAlias& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetLeAdapterAlias();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAlias(IN const BTSDeviceName& alias) { _alias = alias; }

   inline void getAlias(OUT BTSDeviceName& alias) const { alias = _alias; }
   inline const BTSDeviceName& getAlias(void) const { return _alias; }
   inline BTSDeviceName& getAliasMutable(void) { return _alias; }

private:
   BTSDeviceName _alias; /**< parameter alias */
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterAdvertisingTimeout : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterAdvertisingTimeout();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterAdvertisingTimeout(IN const Bts2Ipc_GetLeAdapterAdvertisingTimeout& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterAdvertisingTimeout& operator=(IN const Bts2Ipc_GetLeAdapterAdvertisingTimeout& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterAdvertisingTimeout();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetLeAdapterAdvertisingTimeout : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetLeAdapterAdvertisingTimeout();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetLeAdapterAdvertisingTimeout(IN const Bts2Ipc_SetLeAdapterAdvertisingTimeout& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetLeAdapterAdvertisingTimeout& operator=(IN const Bts2Ipc_SetLeAdapterAdvertisingTimeout& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetLeAdapterAdvertisingTimeout();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAdvertisingTimeout(IN const BTSBLEAdvertisingTimeout advertisingTimeout) { _advertisingTimeout = advertisingTimeout; }

   inline BTSBLEAdvertisingTimeout getAdvertisingTimeout(void) const { return _advertisingTimeout; }

private:
   BTSBLEAdvertisingTimeout _advertisingTimeout; /**< parameter advertising timeout */
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterDiscoverableMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterDiscoverableMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterDiscoverableMode(IN const Bts2Ipc_GetLeAdapterDiscoverableMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterDiscoverableMode& operator=(IN const Bts2Ipc_GetLeAdapterDiscoverableMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterDiscoverableMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetLeAdapterDiscoverableMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetLeAdapterDiscoverableMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetLeAdapterDiscoverableMode(IN const Bts2Ipc_SetLeAdapterDiscoverableMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetLeAdapterDiscoverableMode& operator=(IN const Bts2Ipc_SetLeAdapterDiscoverableMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetLeAdapterDiscoverableMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDiscoverableMode(IN const BTSBLEDiscoverableMode discoverableMode) { _discoverableMode = discoverableMode; }

   inline BTSBLEDiscoverableMode getDiscoverableMode(void) const { return _discoverableMode; }

private:
   BTSBLEDiscoverableMode _discoverableMode; /**< parameter discoverable mode */
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterAdvertisingData : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterAdvertisingData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterAdvertisingData(IN const Bts2Ipc_GetLeAdapterAdvertisingData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterAdvertisingData& operator=(IN const Bts2Ipc_GetLeAdapterAdvertisingData& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterAdvertisingData();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetLeAdapterAdvertisingData : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetLeAdapterAdvertisingData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetLeAdapterAdvertisingData(IN const Bts2Ipc_SetLeAdapterAdvertisingData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetLeAdapterAdvertisingData& operator=(IN const Bts2Ipc_SetLeAdapterAdvertisingData& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetLeAdapterAdvertisingData();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAdvertisingData(IN const BTSBLEAdvertisingData& advertisingData) { _advertisingData = advertisingData; }

   inline void getAdvertisingData(OUT BTSBLEAdvertisingData& advertisingData) const { advertisingData = _advertisingData; }
   inline const BTSBLEAdvertisingData& getAdvertisingData(void) const { return _advertisingData; }
   inline BTSBLEAdvertisingData& getAdvertisingDataMutable(void) { return _advertisingData; }

private:
   BTSBLEAdvertisingData _advertisingData; /**< parameter advertising data */
};

/**
 *
 */
class Bts2Ipc_GetLeAdapterAdvertiseEnable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeAdapterAdvertiseEnable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeAdapterAdvertiseEnable(IN const Bts2Ipc_GetLeAdapterAdvertiseEnable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeAdapterAdvertiseEnable& operator=(IN const Bts2Ipc_GetLeAdapterAdvertiseEnable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeAdapterAdvertiseEnable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_SetLeAdapterAdvertiseEnable : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetLeAdapterAdvertiseEnable();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetLeAdapterAdvertiseEnable(IN const Bts2Ipc_SetLeAdapterAdvertiseEnable& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetLeAdapterAdvertiseEnable& operator=(IN const Bts2Ipc_SetLeAdapterAdvertiseEnable& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetLeAdapterAdvertiseEnable();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAdvertiseEnable(IN const bool advertiseEnable) { _advertiseEnable = advertiseEnable; }

   inline bool getAdvertiseEnable(void) const { return _advertiseEnable; }

private:
   bool _advertiseEnable; /**< parameter advertise enable */
};

/**
 *
 */
class Bts2Ipc_LeDeviceDisconnect : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_LeDeviceDisconnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_LeDeviceDisconnect(IN const Bts2Ipc_LeDeviceDisconnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_LeDeviceDisconnect& operator=(IN const Bts2Ipc_LeDeviceDisconnect& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_LeDeviceDisconnect();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetLeDeviceAddressType : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeDeviceAddressType();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeDeviceAddressType(IN const Bts2Ipc_GetLeDeviceAddressType& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeDeviceAddressType& operator=(IN const Bts2Ipc_GetLeDeviceAddressType& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeDeviceAddressType();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetLeDeviceAddress : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeDeviceAddress();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeDeviceAddress(IN const Bts2Ipc_GetLeDeviceAddress& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeDeviceAddress& operator=(IN const Bts2Ipc_GetLeDeviceAddress& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeDeviceAddress();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetLeDeviceConnected : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLeDeviceConnected();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLeDeviceConnected(IN const Bts2Ipc_GetLeDeviceConnected& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLeDeviceConnected& operator=(IN const Bts2Ipc_GetLeDeviceConnected& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLeDeviceConnected();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SendSeamlessPairingErrorCode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SendSeamlessPairingErrorCode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SendSeamlessPairingErrorCode(IN const Bts2Ipc_SendSeamlessPairingErrorCode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SendSeamlessPairingErrorCode& operator=(IN const Bts2Ipc_SendSeamlessPairingErrorCode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SendSeamlessPairingErrorCode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setErrorCode(IN const BTSBLEErrorCode& errorCode) { _errorCode = errorCode; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getErrorCode(OUT BTSBLEErrorCode& errorCode) const { errorCode = _errorCode; }
   inline const BTSBLEErrorCode& getErrorCode(void) const { return _errorCode; }
   inline BTSBLEErrorCode& getErrorCodeMutable(void) { return _errorCode; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSBLEErrorCode _errorCode; /**< parameter error code */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SeamlessPairingAllowAccess : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SeamlessPairingAllowAccess();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SeamlessPairingAllowAccess(IN const Bts2Ipc_SeamlessPairingAllowAccess& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SeamlessPairingAllowAccess& operator=(IN const Bts2Ipc_SeamlessPairingAllowAccess& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SeamlessPairingAllowAccess();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setAccept(IN const bool accept) { _accept = accept; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getAccept(void) const { return _accept; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   bool _accept; /**< parameter accept */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_GetSeamlessPairingPairingData : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetSeamlessPairingPairingData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetSeamlessPairingPairingData(IN const Bts2Ipc_GetSeamlessPairingPairingData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetSeamlessPairingPairingData& operator=(IN const Bts2Ipc_GetSeamlessPairingPairingData& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetSeamlessPairingPairingData();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Bts2Ipc_SetSeamlessPairingPairingData : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_SetSeamlessPairingPairingData();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_SetSeamlessPairingPairingData(IN const Bts2Ipc_SetSeamlessPairingPairingData& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_SetSeamlessPairingPairingData& operator=(IN const Bts2Ipc_SetSeamlessPairingPairingData& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_SetSeamlessPairingPairingData();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setPairingData(IN const BTSBLEPairingData& pairingData) { _pairingData = pairingData; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getPairingData(OUT BTSBLEPairingData& pairingData) const { pairingData = _pairingData; }
   inline const BTSBLEPairingData& getPairingData(void) const { return _pairingData; }
   inline BTSBLEPairingData& getPairingDataMutable(void) { return _pairingData; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
   BTSBLEPairingData _pairingData; /**< parameter pairing data */
};

} //genivi
} //btstackif

#endif //_BTS_2_IPC_CONNECTION_MSG_GENIVI_H_
